/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.agent;

import io.skylite.core.common.Strings;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class LLMSpec
implements ToXContentObject {
    public static final String MODEL_ID_FIELD = "model_id";
    public static final String PARAMETERS_FIELD = "parameters";
    private final String modelId;
    private final Map<String, String> parameters;

    public LLMSpec(String modelId, Map<String, String> parameters) {
        if (modelId == null) {
            throw new IllegalArgumentException("model id cannot be null");
        }
        this.modelId = modelId;
        this.parameters = parameters != null ? new HashMap<String, String>(parameters) : Map.of();
    }

    public LLMSpec(StreamInput input) throws IOException {
        this.modelId = input.readString();
        this.parameters = input.readBoolean() ? input.readMap(StreamInput::readString, StreamInput::readOptionalString) : Map.of();
    }

    public String getModelId() {
        return this.modelId;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.modelId);
        out.writeBoolean(!this.parameters.isEmpty());
        if (!this.parameters.isEmpty()) {
            out.writeMap(this.parameters, StreamOutput::writeString, StreamOutput::writeOptionalString);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject().field(MODEL_ID_FIELD, this.modelId);
        if (!this.parameters.isEmpty()) {
            builder.field(PARAMETERS_FIELD, this.parameters);
        }
        return builder.endObject();
    }

    public static LLMSpec parse(XContentParser parser) throws IOException {
        String modelId = null;
        Map parameters = Map.of();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block8: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "model_id": {
                    modelId = parser.text();
                    continue block8;
                }
                case "parameters": {
                    parameters = Strings.getParameterMap((Map)parser.map());
                    continue block8;
                }
            }
            parser.skipChildren();
        }
        return new LLMSpec(modelId, parameters);
    }

    public static LLMSpec fromStream(StreamInput in) throws IOException {
        return new LLMSpec(in);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LLMSpec llmSpec = (LLMSpec)o;
        return this.modelId.equals(llmSpec.modelId) && this.parameters.equals(llmSpec.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.modelId, this.parameters);
    }

    public String toString() {
        return "LLMSpec{modelId='" + this.modelId + "', parameters=" + String.valueOf(this.parameters) + "}";
    }

    public static class Builder {
        private String modelId;
        private Map<String, String> parameters = Map.of();

        public Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public Builder parameters(Map<String, String> parameters) {
            this.parameters = parameters != null ? new HashMap<String, String>(parameters) : Map.of();
            return this;
        }

        public LLMSpec build() {
            return new LLMSpec(this.modelId, this.parameters);
        }
    }
}

