/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.agent;

import io.skylite.Version;
import io.skylite.core.common.Strings;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.ml.common.CommonValue;
import io.skylite.ml.common.MLAgentType;
import io.skylite.ml.common.agent.LLMSpec;
import io.skylite.ml.common.agent.MLMemorySpec;
import io.skylite.ml.common.agent.MLToolSpec;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class MLAgent
implements ToXContentObject,
Writeable {
    public static final String AGENT_NAME_FIELD = "name";
    public static final String AGENT_TYPE_FIELD = "type";
    public static final String DESCRIPTION_FIELD = "description";
    public static final String LLM_FIELD = "llm";
    public static final String TOOLS_FIELD = "tools";
    public static final String PARAMETERS_FIELD = "parameters";
    public static final String MEMORY_FIELD = "memory";
    public static final String MEMORY_ID_FIELD = "memory_id";
    public static final String CREATED_TIME_FIELD = "created_time";
    public static final String LAST_UPDATED_TIME_FIELD = "last_updated_time";
    public static final String APP_TYPE_FIELD = "app_type";
    public static final String IS_HIDDEN_FIELD = "is_hidden";
    private static final Version MINIMAL_SUPPORTED_VERSION_FOR_HIDDEN_AGENT = CommonValue.VERSION_2_13_0;
    private String name;
    private String type;
    private String description;
    private LLMSpec llm;
    private List<MLToolSpec> tools;
    private Map<String, String> parameters;
    private MLMemorySpec memory;
    private Instant createdTime;
    private Instant lastUpdateTime;
    private String appType;
    private Boolean isHidden;
    private final String tenantId;

    public MLAgent(String name, String type, String description, LLMSpec llm, List<MLToolSpec> tools, Map<String, String> parameters, MLMemorySpec memory, Instant createdTime, Instant lastUpdateTime, String appType, Boolean isHidden, String tenantId) {
        this.name = name;
        this.type = type;
        this.description = description;
        this.llm = llm;
        this.tools = tools;
        this.parameters = parameters;
        this.memory = memory;
        this.createdTime = createdTime;
        this.lastUpdateTime = lastUpdateTime;
        this.appType = appType;
        this.isHidden = isHidden;
        this.tenantId = tenantId;
        this.validate();
    }

    private void validate() {
        if (this.name == null) {
            throw new IllegalArgumentException("Agent name can't be null");
        }
        this.validateMLAgentType(this.type);
        if (this.type.equalsIgnoreCase(MLAgentType.CONVERSATIONAL.toString()) && this.llm == null) {
            throw new IllegalArgumentException("We need model information for the conversational agent type");
        }
        HashSet<String> toolNames = new HashSet<String>();
        if (this.tools != null) {
            for (MLToolSpec toolSpec : this.tools) {
                String toolName = Optional.ofNullable(toolSpec.getName()).orElse(toolSpec.getType());
                if (toolNames.contains(toolName)) {
                    throw new IllegalArgumentException("Duplicate tool defined: " + toolName);
                }
                toolNames.add(toolName);
            }
        }
    }

    private void validateMLAgentType(String agentType) {
        if (this.type == null) {
            throw new IllegalArgumentException("Agent type can't be null");
        }
        try {
            MLAgentType.valueOf(agentType.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(agentType + " is not a valid Agent Type");
        }
    }

    public MLAgent(StreamInput input) throws IOException {
        Version streamInputVersion = input.getVersion();
        this.name = input.readString();
        this.type = input.readString();
        this.description = input.readOptionalString();
        if (input.readBoolean()) {
            this.llm = new LLMSpec(input);
        }
        if (input.readBoolean()) {
            this.tools = new ArrayList<MLToolSpec>();
            int size = input.readInt();
            for (int i = 0; i < size; ++i) {
                this.tools.add(new MLToolSpec(input));
            }
        }
        if (input.readBoolean()) {
            this.parameters = input.readMap(StreamInput::readString, StreamInput::readOptionalString);
        }
        if (input.readBoolean()) {
            this.memory = new MLMemorySpec(input);
        }
        this.createdTime = input.readOptionalInstant();
        this.lastUpdateTime = input.readOptionalInstant();
        this.appType = input.readOptionalString();
        if (streamInputVersion.onOrAfter(MINIMAL_SUPPORTED_VERSION_FOR_HIDDEN_AGENT)) {
            this.isHidden = input.readOptionalBoolean();
        }
        this.tenantId = streamInputVersion.onOrAfter((Version)CommonValue.VERSION_2_19_0) ? input.readOptionalString() : null;
        this.validate();
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public LLMSpec getLlm() {
        return this.llm;
    }

    public List<MLToolSpec> getTools() {
        return this.tools;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public MLMemorySpec getMemory() {
        return this.memory;
    }

    public Instant getCreatedTime() {
        return this.createdTime;
    }

    public Instant getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public String getAppType() {
        return this.appType;
    }

    public Boolean getIsHidden() {
        return this.isHidden;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().name(this.name).type(this.type).description(this.description).llm(this.llm).tools(this.tools).parameters(this.parameters).memory(this.memory).createdTime(this.createdTime).lastUpdateTime(this.lastUpdateTime).appType(this.appType).isHidden(this.isHidden).tenantId(this.tenantId);
    }

    public void writeTo(StreamOutput out) throws IOException {
        Version streamOutputVersion = out.getVersion();
        out.writeString(this.name);
        out.writeString(this.type);
        out.writeOptionalString(this.description);
        if (this.llm != null) {
            out.writeBoolean(true);
            this.llm.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        if (this.tools != null && !this.tools.isEmpty()) {
            out.writeBoolean(true);
            out.writeInt(this.tools.size());
            for (MLToolSpec tool : this.tools) {
                tool.writeTo(out);
            }
        } else {
            out.writeBoolean(false);
        }
        if (this.parameters != null && !this.parameters.isEmpty()) {
            out.writeBoolean(true);
            out.writeMap(this.parameters, StreamOutput::writeString, StreamOutput::writeOptionalString);
        } else {
            out.writeBoolean(false);
        }
        if (this.memory != null) {
            out.writeBoolean(true);
            this.memory.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalInstant(this.createdTime);
        out.writeOptionalInstant(this.lastUpdateTime);
        out.writeOptionalString(this.appType);
        if (streamOutputVersion.onOrAfter(MINIMAL_SUPPORTED_VERSION_FOR_HIDDEN_AGENT)) {
            out.writeOptionalBoolean(this.isHidden);
        }
        if (streamOutputVersion.onOrAfter((Version)CommonValue.VERSION_2_19_0)) {
            out.writeOptionalString(this.tenantId);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.name != null) {
            builder.field(AGENT_NAME_FIELD, this.name);
        }
        if (this.type != null) {
            builder.field(AGENT_TYPE_FIELD, this.type);
        }
        if (this.description != null) {
            builder.field(DESCRIPTION_FIELD, this.description);
        }
        if (this.llm != null) {
            builder.field(LLM_FIELD, (ToXContent)this.llm);
        }
        if (this.tools != null && this.tools.size() > 0) {
            builder.field(TOOLS_FIELD, this.tools);
        }
        if (this.parameters != null && this.parameters.size() > 0) {
            builder.field(PARAMETERS_FIELD, this.parameters);
        }
        if (this.memory != null) {
            builder.field(MEMORY_FIELD, (ToXContent)this.memory);
        }
        if (this.createdTime != null) {
            builder.field(CREATED_TIME_FIELD, this.createdTime.toEpochMilli());
        }
        if (this.lastUpdateTime != null) {
            builder.field(LAST_UPDATED_TIME_FIELD, this.lastUpdateTime.toEpochMilli());
        }
        if (this.appType != null) {
            builder.field(APP_TYPE_FIELD, this.appType);
        }
        if (this.isHidden != null) {
            builder.field(IS_HIDDEN_FIELD, this.isHidden);
        }
        if (this.tenantId != null) {
            builder.field("tenant_id", this.tenantId);
        }
        builder.endObject();
        return builder;
    }

    public static MLAgent parse(XContentParser parser) throws IOException {
        return MLAgent.parseCommonFields(parser, true);
    }

    public static MLAgent parseFromUserInput(XContentParser parser) throws IOException {
        return MLAgent.parseCommonFields(parser, false);
    }

    private static MLAgent parseCommonFields(XContentParser parser, boolean parseHidden) throws IOException {
        String name = null;
        String type = null;
        String description = null;
        LLMSpec llm = null;
        ArrayList<MLToolSpec> tools = null;
        Map parameters = null;
        MLMemorySpec memory = null;
        Instant createdTime = null;
        Instant lastUpdateTime = null;
        String appType = null;
        boolean isHidden = false;
        String tenantId = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block28: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "name": {
                    name = parser.text();
                    continue block28;
                }
                case "type": {
                    type = parser.text();
                    continue block28;
                }
                case "description": {
                    description = parser.text();
                    continue block28;
                }
                case "llm": {
                    llm = LLMSpec.parse(parser);
                    continue block28;
                }
                case "tools": {
                    tools = new ArrayList<MLToolSpec>();
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        tools.add(MLToolSpec.parse(parser));
                    }
                    continue block28;
                }
                case "parameters": {
                    parameters = Strings.getParameterMap((Map)parser.map());
                    continue block28;
                }
                case "memory": {
                    memory = MLMemorySpec.parse(parser);
                    continue block28;
                }
                case "created_time": {
                    createdTime = Instant.ofEpochMilli(parser.longValue());
                    continue block28;
                }
                case "last_updated_time": {
                    lastUpdateTime = Instant.ofEpochMilli(parser.longValue());
                    continue block28;
                }
                case "app_type": {
                    appType = parser.text();
                    continue block28;
                }
                case "is_hidden": {
                    if (!parseHidden) continue block28;
                    isHidden = parser.booleanValue();
                    continue block28;
                }
                case "tenant_id": {
                    tenantId = parser.textOrNull();
                    continue block28;
                }
            }
            parser.skipChildren();
        }
        return MLAgent.builder().name(name).type(type).description(description).llm(llm).tools(tools).parameters(parameters).memory(memory).createdTime(createdTime).lastUpdateTime(lastUpdateTime).appType(appType).isHidden(isHidden).tenantId(tenantId).build();
    }

    public static MLAgent fromStream(StreamInput in) throws IOException {
        return new MLAgent(in);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MLAgent mlAgent = (MLAgent)o;
        return Objects.equals(this.name, mlAgent.name) && Objects.equals(this.type, mlAgent.type) && Objects.equals(this.description, mlAgent.description) && Objects.equals(this.llm, mlAgent.llm) && Objects.equals(this.tools, mlAgent.tools) && Objects.equals(this.parameters, mlAgent.parameters) && Objects.equals(this.memory, mlAgent.memory) && Objects.equals(this.createdTime, mlAgent.createdTime) && Objects.equals(this.lastUpdateTime, mlAgent.lastUpdateTime) && Objects.equals(this.appType, mlAgent.appType) && this.isHidden == mlAgent.isHidden && Objects.equals(this.tenantId, mlAgent.tenantId);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.llm != null ? this.llm.hashCode() : 0);
        result = 31 * result + (this.tools != null ? this.tools.hashCode() : 0);
        result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
        result = 31 * result + (this.memory != null ? this.memory.hashCode() : 0);
        result = 31 * result + (this.createdTime != null ? this.createdTime.hashCode() : 0);
        result = 31 * result + (this.lastUpdateTime != null ? this.lastUpdateTime.hashCode() : 0);
        result = 31 * result + (this.appType != null ? this.appType.hashCode() : 0);
        result = 31 * result + (this.isHidden != null ? Boolean.hashCode(this.isHidden) : 0);
        result = 31 * result + (this.tenantId != null ? this.tenantId.hashCode() : 0);
        return result;
    }

    public static class Builder {
        private String name;
        private String type;
        private String description;
        private LLMSpec llm;
        private List<MLToolSpec> tools;
        private Map<String, String> parameters;
        private MLMemorySpec memory;
        private Instant createdTime;
        private Instant lastUpdateTime;
        private String appType;
        private Boolean isHidden;
        private String tenantId;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder llm(LLMSpec llm) {
            this.llm = llm;
            return this;
        }

        public Builder tools(List<MLToolSpec> tools) {
            this.tools = tools;
            return this;
        }

        public Builder parameters(Map<String, String> parameters) {
            this.parameters = parameters;
            return this;
        }

        public Builder memory(MLMemorySpec memory) {
            this.memory = memory;
            return this;
        }

        public Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public Builder appType(String appType) {
            this.appType = appType;
            return this;
        }

        public Builder isHidden(Boolean hidden) {
            this.isHidden = hidden;
            return this;
        }

        public Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public MLAgent build() {
            return new MLAgent(this.name, this.type, this.description, this.llm, this.tools, this.parameters, this.memory, this.createdTime, this.lastUpdateTime, this.appType, this.isHidden, this.tenantId);
        }
    }
}

