/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.agent;

import io.skylite.OpenSearchVersion;
import io.skylite.Version;
import io.skylite.core.common.Strings;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.ml.common.CommonValue;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class MLToolSpec
implements ToXContentObject {
    public static final OpenSearchVersion MINIMAL_SUPPORTED_VERSION_FOR_TOOL_CONFIG = CommonValue.VERSION_2_18_0;
    public static final String TOOL_TYPE_FIELD = "type";
    public static final String TOOL_NAME_FIELD = "name";
    public static final String DESCRIPTION_FIELD = "description";
    public static final String PARAMETERS_FIELD = "parameters";
    public static final String INCLUDE_OUTPUT_IN_AGENT_RESPONSE = "include_output_in_agent_response";
    public static final String CONFIG_FIELD = "config";
    public static final String RUN_TIME_RESOURCES_FIELD = "runtime_resources";
    public static final String ATTRIBUTES_FIELD = "attributes";
    private final String type;
    private final String name;
    private final String description;
    private final Map<String, String> parameters;
    private Map<String, String> attributes;
    private final boolean includeOutputInAgentResponse;
    private final Map<String, String> configMap;
    private String tenantId;
    private Map<String, Object> runtimeResources;

    public MLToolSpec(String type, String name, String description, Map<String, String> parameters, Map<String, String> attributes, boolean includeOutputInAgentResponse, Map<String, String> configMap, String tenantId, Map<String, Object> runtimeResources) {
        if (type == null) {
            throw new IllegalArgumentException("tool type is null");
        }
        this.type = type;
        this.name = name;
        this.description = description;
        this.parameters = parameters;
        this.includeOutputInAgentResponse = includeOutputInAgentResponse;
        this.configMap = configMap;
        this.tenantId = tenantId;
        this.attributes = attributes;
        this.runtimeResources = runtimeResources;
    }

    public MLToolSpec(StreamInput input) throws IOException {
        Version streamInputVersion = input.getVersion();
        this.type = input.readString();
        this.name = input.readOptionalString();
        this.description = input.readOptionalString();
        this.parameters = input.readBoolean() ? input.readMap(StreamInput::readString, StreamInput::readOptionalString) : null;
        this.includeOutputInAgentResponse = input.readBoolean();
        this.configMap = input.getVersion().onOrAfter((Version)MINIMAL_SUPPORTED_VERSION_FOR_TOOL_CONFIG) && input.readBoolean() ? input.readMap(StreamInput::readString, StreamInput::readOptionalString) : null;
        this.tenantId = streamInputVersion.onOrAfter((Version)CommonValue.VERSION_2_19_0) ? input.readOptionalString() : null;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public boolean isIncludeOutputInAgentResponse() {
        return this.includeOutputInAgentResponse;
    }

    public Map<String, String> getConfigMap() {
        return this.configMap;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void writeTo(StreamOutput out) throws IOException {
        Version streamOutputVersion = out.getVersion();
        out.writeString(this.type);
        out.writeOptionalString(this.name);
        out.writeOptionalString(this.description);
        out.writeBoolean(this.parameters != null);
        if (this.parameters != null) {
            out.writeMap(this.parameters, StreamOutput::writeString, StreamOutput::writeOptionalString);
        }
        out.writeBoolean(this.includeOutputInAgentResponse);
        if (out.getVersion().onOrAfter((Version)MINIMAL_SUPPORTED_VERSION_FOR_TOOL_CONFIG)) {
            out.writeBoolean(this.configMap != null);
            if (this.configMap != null) {
                out.writeMap(this.configMap, StreamOutput::writeString, StreamOutput::writeOptionalString);
            }
        }
        if (streamOutputVersion.onOrAfter((Version)CommonValue.VERSION_2_19_0)) {
            out.writeOptionalString(this.tenantId);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(TOOL_TYPE_FIELD, this.type);
        if (this.name != null) {
            builder.field(TOOL_NAME_FIELD, this.name);
        }
        if (this.description != null) {
            builder.field(DESCRIPTION_FIELD, this.description);
        }
        if (this.parameters != null && !this.parameters.isEmpty()) {
            builder.field(PARAMETERS_FIELD, this.parameters);
        }
        builder.field(INCLUDE_OUTPUT_IN_AGENT_RESPONSE, this.includeOutputInAgentResponse);
        if (this.configMap != null && !this.configMap.isEmpty()) {
            builder.field(CONFIG_FIELD, this.configMap);
        }
        if (this.tenantId != null) {
            builder.field("tenant_id", this.tenantId);
        }
        builder.endObject();
        return builder;
    }

    public static MLToolSpec parse(XContentParser parser) throws IOException {
        String type = null;
        String name = null;
        String description = null;
        Map attributes = null;
        Map parameters = null;
        boolean includeOutputInAgentResponse = false;
        Map configMap = null;
        String tenantId = null;
        Map runtimeResources = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block22: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "type": {
                    type = parser.text();
                    continue block22;
                }
                case "name": {
                    name = parser.text();
                    continue block22;
                }
                case "description": {
                    description = parser.text();
                    continue block22;
                }
                case "attributes": {
                    attributes = Strings.getParameterMap((Map)parser.map());
                    continue block22;
                }
                case "parameters": {
                    parameters = Strings.getParameterMap((Map)parser.map());
                    continue block22;
                }
                case "include_output_in_agent_response": {
                    includeOutputInAgentResponse = parser.booleanValue();
                    continue block22;
                }
                case "config": {
                    configMap = Strings.getParameterMap((Map)parser.map());
                    continue block22;
                }
                case "tenant_id": {
                    tenantId = parser.textOrNull();
                    continue block22;
                }
                case "runtime_resources": {
                    runtimeResources = parser.map();
                    continue block22;
                }
            }
            parser.skipChildren();
        }
        return MLToolSpec.builder().type(type).name(name).description(description).attributes(attributes).parameters(parameters).includeOutputInAgentResponse(includeOutputInAgentResponse).configMap(configMap).tenantId(tenantId).runtimeResources(runtimeResources).build();
    }

    public static MLToolSpec fromStream(StreamInput in) throws IOException {
        return new MLToolSpec(in);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MLToolSpec that = (MLToolSpec)o;
        return this.includeOutputInAgentResponse == that.includeOutputInAgentResponse && Objects.equals(this.type, that.type) && Objects.equals(this.name, that.name) && Objects.equals(this.description, that.description) && Objects.equals(this.parameters, that.parameters) && Objects.equals(this.configMap, that.configMap) && Objects.equals(this.tenantId, that.tenantId);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.name, this.description, this.parameters, this.includeOutputInAgentResponse, this.configMap, this.tenantId);
    }

    public void addRuntimeResource(String key, Object value) {
        if (this.runtimeResources == null) {
            this.runtimeResources = new HashMap<String, Object>();
        }
        this.runtimeResources.put(key, value);
    }

    public Object getRuntimeResource(String key) {
        return this.runtimeResources.get(key);
    }

    public Map<String, Object> getRuntimeResources() {
        return this.runtimeResources;
    }

    public static class Builder {
        private String type;
        private String name;
        private String description;
        private Map<String, String> parameters;
        private boolean includeOutputInAgentResponse;
        private Map<String, String> configMap;
        private String tenantId;
        private Map<String, String> attributes;
        private Map<String, Object> runtimeResources;

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder parameters(Map<String, String> parameters) {
            this.parameters = parameters;
            return this;
        }

        public Builder includeOutputInAgentResponse(boolean includeOutputInAgentResponse) {
            this.includeOutputInAgentResponse = includeOutputInAgentResponse;
            return this;
        }

        public Builder configMap(Map<String, String> configMap) {
            this.configMap = configMap;
            return this;
        }

        public Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public Builder attributes(Map<String, String> attributes) {
            this.attributes = attributes;
            return this;
        }

        public Builder runtimeResources(Map<String, Object> runtimeResources) {
            this.runtimeResources = runtimeResources;
            return this;
        }

        public MLToolSpec build() {
            return new MLToolSpec(this.type, this.name, this.description, this.parameters, this.attributes, this.includeOutputInAgentResponse, this.configMap, this.tenantId, this.runtimeResources);
        }
    }
}

