/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.breaker;

import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.monitor.jvm.JvmService;
import io.skylite.core.monitor.os.OsService;
import io.skylite.core.settings.Settings;
import io.skylite.ml.common.breaker.BreakerName;
import io.skylite.ml.common.breaker.DiskCircuitBreaker;
import io.skylite.ml.common.breaker.MLCircuitBreaker;
import io.skylite.ml.common.breaker.MemoryCircuitBreaker;
import io.skylite.ml.common.breaker.ThresholdCircuitBreaker;
import java.nio.file.Path;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MLCircuitBreakerService {
    private static final Logger log = LogManager.getLogger(MLCircuitBreakerService.class);
    private final ConcurrentMap<BreakerName, MLCircuitBreaker> breakers = new ConcurrentHashMap<BreakerName, MLCircuitBreaker>();
    private final JvmService jvmService;
    private final OsService osService;
    private final Settings settings;
    private final ClusterService clusterService;

    public MLCircuitBreakerService(JvmService jvmService, OsService osService, Settings settings, ClusterService clusterService) {
        this.jvmService = jvmService;
        this.osService = osService;
        this.settings = settings;
        this.clusterService = clusterService;
    }

    public void registerBreaker(BreakerName name, MLCircuitBreaker breaker) {
        this.breakers.putIfAbsent(name, breaker);
    }

    public void unregisterBreaker(BreakerName name) {
        if (name == null) {
            return;
        }
        this.breakers.remove((Object)name);
        log.info("Removed ML breakers " + String.valueOf((Object)name));
    }

    public void clearBreakers() {
        this.breakers.clear();
        log.info("Cleared ML breakers.");
    }

    public MLCircuitBreaker getBreaker(BreakerName name) {
        return (MLCircuitBreaker)this.breakers.get((Object)name);
    }

    public MLCircuitBreakerService init(Path path) {
        this.registerBreaker(BreakerName.MEMORY, new MemoryCircuitBreaker(this.settings, this.clusterService, this.jvmService));
        log.info("Registered ML memory breaker.");
        this.registerBreaker(BreakerName.DISK, new DiskCircuitBreaker(this.settings, this.clusterService, path));
        log.info("Registered ML disk breaker.");
        log.info("Registered ML native memory breaker.");
        return this;
    }

    public ThresholdCircuitBreaker checkOpenCB() {
        for (MLCircuitBreaker breaker : this.breakers.values()) {
            if (!breaker.isOpen()) continue;
            return (ThresholdCircuitBreaker)breaker;
        }
        return null;
    }
}

