/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.breaker;

import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.monitor.os.OsService;
import io.skylite.core.settings.Settings;
import io.skylite.ml.common.breaker.ThresholdCircuitBreaker;
import io.skylite.ml.common.settings.MLCommonsSettings;
import java.util.Optional;

public class NativeMemoryCircuitBreaker
extends ThresholdCircuitBreaker<Short> {
    private static final String ML_MEMORY_CB = "Native Memory Circuit Breaker";
    public static final short DEFAULT_NATIVE_MEM_USAGE_THRESHOLD = 90;
    private final OsService osService;

    public NativeMemoryCircuitBreaker(OsService osService, Settings settings, ClusterService clusterService) {
        super(Optional.ofNullable((Integer)MLCommonsSettings.ML_COMMONS_NATIVE_MEM_THRESHOLD.get(settings)).map(Integer::shortValue).orElse((short)90));
        this.osService = osService;
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_NATIVE_MEM_THRESHOLD, it -> super.setThreshold(it.shortValue()));
    }

    public NativeMemoryCircuitBreaker(Integer threshold, OsService osService) {
        super(threshold.shortValue());
        this.osService = osService;
    }

    @Override
    public String getName() {
        return ML_MEMORY_CB;
    }

    @Override
    public boolean isOpen() {
        return this.osService.stats().getMem().getUsedPercent() > (Short)this.getThreshold();
    }
}

