/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.client;

import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.IOException;
import java.util.Objects;

public class Configuration
implements ToXContentObject,
Writeable {
    public static final String ROOT_AGENT_ID = "agent_id";
    private String agentId;

    public Configuration(String agentId) {
        this.agentId = agentId;
    }

    public Configuration(StreamInput input) throws IOException {
        this.agentId = input.readOptionalString();
    }

    public String getAgentId() {
        return this.agentId;
    }

    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.agentId);
    }

    public XContentBuilder toXContent(XContentBuilder xContentBuilder, ToXContent.Params params) throws IOException {
        XContentBuilder builder = xContentBuilder.startObject();
        if (this.agentId != null) {
            builder.field(ROOT_AGENT_ID, this.agentId);
        }
        return builder.endObject();
    }

    public static Configuration fromStream(StreamInput in) throws IOException {
        Configuration configuration = new Configuration(in);
        return configuration;
    }

    public static Configuration parse(XContentParser parser) throws IOException {
        String agentId = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block6: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "agent_id": {
                    agentId = parser.text();
                    continue block6;
                }
            }
            parser.skipChildren();
        }
        return Configuration.builder().agentId(agentId).build();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Configuration that = (Configuration)o;
        return Objects.equals(this.agentId, that.agentId);
    }

    public int hashCode() {
        return Objects.hashCode(this.agentId);
    }

    public static class Builder {
        private String agentId;

        public Builder agentId(String agentId) {
            this.agentId = agentId;
            return this;
        }

        public Configuration build() {
            return new Configuration(this.agentId);
        }
    }
}

