/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.cluster;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.ValidationMessage;
import io.skylite.SkyliteParseException;
import io.skylite.core.common.breaker.CircuitBreaker;
import io.skylite.core.common.breaker.CircuitBreakingException;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.xcontent.DeprecationHandler;
import io.skylite.core.xcontent.LoggingDeprecationHandler;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.XContentHelper;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.ml.common.breaker.MLCircuitBreakerService;
import io.skylite.ml.common.breaker.ThresholdCircuitBreaker;
import io.skylite.ml.common.stats.MLNodeLevelStat;
import io.skylite.ml.common.stats.MLStats;
import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Function;

public final class MLNodeUtils {
    public static XContentParser createXContentParserFromRegistry(NamedXContentRegistry xContentRegistry, BytesReference bytesReference) throws IOException {
        return XContentHelper.createParser((NamedXContentRegistry)xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (BytesReference)bytesReference, (MediaType)MediaTypeRegistry.JSON);
    }

    public static void parseArrayField(XContentParser parser, Set<String> set) throws IOException {
        MLNodeUtils.parseField(parser, set, null, String.class);
    }

    public static <T> void parseField(XContentParser parser, Set<T> set, Function<String, T> function, Class<T> clazz) throws IOException {
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
            String value = parser.text();
            if (function != null) {
                set.add(function.apply(value));
                continue;
            }
            if (!clazz.isInstance(value)) continue;
            set.add(clazz.cast(value));
        }
    }

    public static void validateSchema(String schemaString, String instanceString) throws IOException {
        JsonNode jsonNode;
        ObjectMapper mapper = new ObjectMapper();
        JsonNode schemaNode = mapper.readTree(schemaString);
        JsonSchema schema = JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)SpecVersion.VersionFlag.V202012).getSchema(schemaNode);
        Set errors = schema.validate(jsonNode = mapper.readTree(instanceString));
        if (!errors.isEmpty()) {
            throw new SkyliteParseException("Validation failed: " + Arrays.toString(errors.toArray(new ValidationMessage[0])) + " for instance: " + instanceString + " with schema: " + schemaString, new Object[0]);
        }
    }

    public static String processRemoteInferenceInputDataSetParametersValue(String inputJson) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode rootNode = mapper.readTree(inputJson);
        if (rootNode.has("parameters") && rootNode.get("parameters").isObject()) {
            ObjectNode parametersNode = (ObjectNode)rootNode.get("parameters");
            parametersNode.fields().forEachRemaining(entry -> {
                String key = (String)entry.getKey();
                JsonNode value = (JsonNode)entry.getValue();
                if (value.isTextual()) {
                    String textValue = value.asText();
                    try {
                        JsonNode parsedValue = mapper.readTree(textValue);
                        parametersNode.set(key, parsedValue);
                    }
                    catch (IOException e) {
                        parametersNode.set(key, value);
                    }
                }
            });
        }
        return mapper.writeValueAsString((Object)rootNode);
    }

    public static void checkOpenCircuitBreaker(MLCircuitBreakerService mlCircuitBreakerService, MLStats mlStats) {
        ThresholdCircuitBreaker openCircuitBreaker = mlCircuitBreakerService.checkOpenCB();
        if (openCircuitBreaker != null) {
            mlStats.getStat(MLNodeLevelStat.ML_CIRCUIT_BREAKER_TRIGGER_COUNT).increment();
            throw new CircuitBreakingException(openCircuitBreaker.getName() + " is open, please check your resources!", CircuitBreaker.Durability.TRANSIENT);
        }
    }
}

