/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.connector;

import io.skylite.core.common.Strings;
import io.skylite.core.security.auth.User;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.ml.common.AccessMode;
import io.skylite.ml.common.connector.Connector;
import io.skylite.ml.common.connector.ConnectorAction;
import io.skylite.ml.common.connector.ConnectorClientConfig;
import io.skylite.ml.common.output.model.ModelTensor;
import java.io.IOException;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.text.StringSubstitutor;

public abstract class AbstractConnector
implements Connector {
    public static final String ACCESS_KEY_FIELD = "access_key";
    public static final String SECRET_KEY_FIELD = "secret_key";
    public static final String SESSION_TOKEN_FIELD = "session_token";
    public static final String NAME_FIELD = "name";
    public static final String VERSION_FIELD = "version";
    public static final String DESCRIPTION_FIELD = "description";
    public static final String PROTOCOL_FIELD = "protocol";
    public static final String ACTIONS_FIELD = "actions";
    public static final String CREDENTIAL_FIELD = "credential";
    public static final String PARAMETERS_FIELD = "parameters";
    public static final String CREATED_TIME_FIELD = "created_time";
    public static final String LAST_UPDATED_TIME_FIELD = "last_updated_time";
    public static final String BACKEND_ROLES_FIELD = "backend_roles";
    public static final String OWNER_FIELD = "owner";
    public static final String ACCESS_FIELD = "access";
    public static final String CLIENT_CONFIG_FIELD = "client_config";
    protected String name;
    protected String description;
    protected String version;
    protected String protocol;
    protected Map<String, String> parameters;
    protected Map<String, String> credential;
    protected Map<String, String> decryptedHeaders;
    protected Map<String, String> decryptedCredential;
    protected List<ConnectorAction> actions;
    protected List<String> backendRoles;
    protected User owner;
    protected AccessMode access;
    protected Instant createdTime;
    protected Instant lastUpdateTime;
    protected ConnectorClientConfig connectorClientConfig;
    protected String tenantId;

    protected Map<String, String> createDecryptedHeaders(Map<String, String> headers) {
        if (headers == null) {
            return null;
        }
        HashMap<String, String> decryptedHeaders = new HashMap<String, String>();
        StringSubstitutor substitutor = new StringSubstitutor(this.getDecryptedCredential(), "${credential.", "}");
        for (String key : headers.keySet()) {
            decryptedHeaders.put(key, substitutor.replace(headers.get(key)));
        }
        if (this.parameters != null && !this.parameters.isEmpty()) {
            substitutor = new StringSubstitutor(this.parameters, "${parameters.", "}");
            for (String key : decryptedHeaders.keySet()) {
                decryptedHeaders.put(key, substitutor.replace((String)decryptedHeaders.get(key)));
            }
        }
        return decryptedHeaders;
    }

    @Override
    public <T> void parseResponse(T response, List<ModelTensor> modelTensors, boolean modelTensorJson) throws IOException {
        if (modelTensorJson) {
            String modelTensorJsonContent = (String)response;
            XContentParser parser = MediaTypeRegistry.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, null, modelTensorJsonContent);
            parser.nextToken();
            if (XContentParser.Token.START_ARRAY == parser.currentToken()) {
                while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                    ModelTensor modelTensor = ModelTensor.parser(parser);
                    modelTensors.add(modelTensor);
                }
            } else {
                ModelTensor modelTensor = ModelTensor.parser(parser);
                modelTensors.add(modelTensor);
            }
            return;
        }
        if (response instanceof String && Strings.isJson((String)((String)response))) {
            Map data = Strings.fromJson((String)((String)response), (String)"response");
            modelTensors.add(ModelTensor.builder().name("response").dataAsMap(data).build());
        } else {
            HashMap<String, T> map = new HashMap<String, T>();
            map.put("response", response);
            modelTensors.add(ModelTensor.builder().name("response").dataAsMap(map).build());
        }
    }

    @Override
    public Optional<ConnectorAction> findAction(String action) {
        if (this.actions != null) {
            return this.actions.stream().filter(a -> a.getActionType().name().equalsIgnoreCase(action)).findFirst();
        }
        return Optional.empty();
    }

    @Override
    public void addAction(ConnectorAction action) {
        this.actions.add(action);
    }

    @Override
    public void removeCredential() {
        this.credential = null;
        this.decryptedCredential = null;
        this.decryptedHeaders = null;
    }

    @Override
    public String getActionEndpoint(String action, Map<String, String> parameters) {
        Optional<ConnectorAction> actionEndpoint = this.findAction(action);
        if (actionEndpoint.isEmpty()) {
            return null;
        }
        String predictEndpoint = actionEndpoint.get().getUrl();
        if (parameters != null && !parameters.isEmpty()) {
            StringSubstitutor substitutor = new StringSubstitutor(parameters, "${parameters.", "}");
            predictEndpoint = substitutor.replace(predictEndpoint);
        }
        return predictEndpoint;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getVersion() {
        return this.version;
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public Map<String, String> getCredential() {
        return this.credential;
    }

    @Override
    public Map<String, String> getDecryptedHeaders() {
        return this.decryptedHeaders;
    }

    @Override
    public Map<String, String> getDecryptedCredential() {
        return this.decryptedCredential;
    }

    @Override
    public List<ConnectorAction> getActions() {
        return this.actions;
    }

    @Override
    public List<String> getBackendRoles() {
        return this.backendRoles;
    }

    @Override
    public User getOwner() {
        return this.owner;
    }

    @Override
    public AccessMode getAccess() {
        return this.access;
    }

    public Instant getCreatedTime() {
        return this.createdTime;
    }

    public Instant getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    @Override
    public ConnectorClientConfig getConnectorClientConfig() {
        return this.connectorClientConfig;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    public void setDecryptedCredential(Map<String, String> decryptedCredential) {
        this.decryptedCredential = decryptedCredential;
    }

    @Override
    public void setBackendRoles(List<String> backendRoles) {
        this.backendRoles = backendRoles;
    }

    @Override
    public void setOwner(User owner) {
        this.owner = owner;
    }

    @Override
    public void setAccess(AccessMode access) {
        this.access = access;
    }

    @Override
    public void setCreatedTime(Instant createdTime) {
        this.createdTime = createdTime;
    }

    @Override
    public void setLastUpdateTime(Instant lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public void setConnectorClientConfig(ConnectorClientConfig connectorClientConfig) {
        this.connectorClientConfig = connectorClientConfig;
    }

    @Override
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractConnector that = (AbstractConnector)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.description, that.description) && Objects.equals(this.version, that.version) && Objects.equals(this.protocol, that.protocol) && Objects.equals(this.parameters, that.parameters) && Objects.equals(this.credential, that.credential) && Objects.equals(this.decryptedHeaders, that.decryptedHeaders) && Objects.equals(this.decryptedCredential, that.decryptedCredential) && Objects.equals(this.actions, that.actions) && Objects.equals(this.backendRoles, that.backendRoles) && Objects.equals(this.owner, that.owner) && this.access == that.access && Objects.equals(this.createdTime, that.createdTime) && Objects.equals(this.lastUpdateTime, that.lastUpdateTime) && Objects.equals(this.connectorClientConfig, that.connectorClientConfig) && Objects.equals(this.tenantId, that.tenantId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.description, this.version, this.protocol, this.parameters, this.credential, this.decryptedHeaders, this.decryptedCredential, this.actions, this.backendRoles, this.owner, this.access, this.createdTime, this.lastUpdateTime, this.connectorClientConfig, this.tenantId});
    }
}

