/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.connector;

import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.IOException;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ConnectorAction
implements ToXContentObject,
Writeable {
    public static final String ACTION_TYPE_FIELD = "action_type";
    public static final String METHOD_FIELD = "method";
    public static final String URL_FIELD = "url";
    public static final String HEADERS_FIELD = "headers";
    public static final String REQUEST_BODY_FIELD = "request_body";
    public static final String ACTION_PRE_PROCESS_FUNCTION = "pre_process_function";
    public static final String ACTION_POST_PROCESS_FUNCTION = "post_process_function";
    private ActionType actionType;
    private String method;
    private String url;
    private Map<String, String> headers;
    private String requestBody;
    private String preProcessFunction;
    private String postProcessFunction;

    public ConnectorAction(ActionType actionType, String method, String url, Map<String, String> headers, String requestBody, String preProcessFunction, String postProcessFunction) {
        if (actionType == null) {
            throw new IllegalArgumentException("action type can't be null");
        }
        if (url == null) {
            throw new IllegalArgumentException("url can't be null");
        }
        if (method == null) {
            throw new IllegalArgumentException("method can't be null");
        }
        this.actionType = actionType;
        this.method = method;
        this.url = url;
        this.headers = headers;
        this.requestBody = requestBody;
        this.preProcessFunction = preProcessFunction;
        this.postProcessFunction = postProcessFunction;
    }

    public ConnectorAction(StreamInput input) throws IOException {
        this.actionType = (ActionType)input.readEnum(ActionType.class);
        this.method = input.readString();
        this.url = input.readString();
        if (input.readBoolean()) {
            this.headers = input.readMap(StreamInput::readString, StreamInput::readString);
        }
        this.requestBody = input.readOptionalString();
        this.preProcessFunction = input.readOptionalString();
        this.postProcessFunction = input.readOptionalString();
    }

    public ActionType getActionType() {
        return this.actionType;
    }

    public String getMethod() {
        return this.method;
    }

    public String getUrl() {
        return this.url;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getRequestBody() {
        return this.requestBody;
    }

    public String getPreProcessFunction() {
        return this.preProcessFunction;
    }

    public String getPostProcessFunction() {
        return this.postProcessFunction;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnum((Enum)this.actionType);
        out.writeString(this.method);
        out.writeString(this.url);
        if (this.headers != null) {
            out.writeBoolean(true);
            out.writeMap(this.headers, StreamOutput::writeString, StreamOutput::writeString);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalString(this.requestBody);
        out.writeOptionalString(this.preProcessFunction);
        out.writeOptionalString(this.postProcessFunction);
    }

    public XContentBuilder toXContent(XContentBuilder xContentBuilder, ToXContent.Params params) throws IOException {
        XContentBuilder builder = xContentBuilder.startObject();
        if (this.actionType != null) {
            builder.field(ACTION_TYPE_FIELD, (Object)this.actionType);
        }
        if (this.method != null) {
            builder.field(METHOD_FIELD, this.method);
        }
        if (this.url != null) {
            builder.field(URL_FIELD, this.url);
        }
        if (this.headers != null) {
            builder.field(HEADERS_FIELD, this.headers);
        }
        if (this.requestBody != null) {
            builder.field(REQUEST_BODY_FIELD, this.requestBody);
        }
        if (this.preProcessFunction != null) {
            builder.field(ACTION_PRE_PROCESS_FUNCTION, this.preProcessFunction);
        }
        if (this.postProcessFunction != null) {
            builder.field(ACTION_POST_PROCESS_FUNCTION, this.postProcessFunction);
        }
        return builder.endObject();
    }

    public static ConnectorAction fromStream(StreamInput in) throws IOException {
        ConnectorAction action = new ConnectorAction(in);
        return action;
    }

    public static ConnectorAction parse(XContentParser parser) throws IOException {
        ActionType actionType = null;
        String method = null;
        String url = null;
        Map headers = null;
        String requestBody = null;
        String preProcessFunction = null;
        String postProcessFunction = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block18: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "action_type": {
                    actionType = ActionType.valueOf(parser.text().toUpperCase(Locale.ROOT));
                    continue block18;
                }
                case "method": {
                    method = parser.text();
                    continue block18;
                }
                case "url": {
                    url = parser.text();
                    continue block18;
                }
                case "headers": {
                    headers = parser.mapStrings();
                    continue block18;
                }
                case "request_body": {
                    requestBody = parser.text();
                    continue block18;
                }
                case "pre_process_function": {
                    preProcessFunction = parser.text();
                    continue block18;
                }
                case "post_process_function": {
                    postProcessFunction = parser.text();
                    continue block18;
                }
            }
            parser.skipChildren();
        }
        return ConnectorAction.builder().actionType(actionType).method(method).url(url).headers(headers).requestBody(requestBody).preProcessFunction(preProcessFunction).postProcessFunction(postProcessFunction).build();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectorAction that = (ConnectorAction)o;
        return this.actionType == that.actionType && Objects.equals(this.method, that.method) && Objects.equals(this.url, that.url) && Objects.equals(this.headers, that.headers) && Objects.equals(this.requestBody, that.requestBody) && Objects.equals(this.preProcessFunction, that.preProcessFunction) && Objects.equals(this.postProcessFunction, that.postProcessFunction);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.actionType, this.method, this.url, this.headers, this.requestBody, this.preProcessFunction, this.postProcessFunction});
    }

    public static enum ActionType {
        PREDICT,
        EXECUTE,
        BATCH_PREDICT,
        CANCEL_BATCH_PREDICT,
        BATCH_PREDICT_STATUS;

        private static final HashSet<ActionType> MODEL_SUPPORT_ACTIONS;

        public static ActionType from(String value) {
            try {
                return ActionType.valueOf(value.toUpperCase(Locale.ROOT));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Wrong Action Type of " + value);
            }
        }

        public static boolean isValidActionInModelPrediction(ActionType actionType) {
            return MODEL_SUPPORT_ACTIONS.contains((Object)actionType);
        }

        public static boolean isValidAction(String action) {
            try {
                ActionType.valueOf(action.toUpperCase(Locale.ROOT));
                return true;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }

        static {
            MODEL_SUPPORT_ACTIONS = new HashSet<ActionType>(Set.of(PREDICT, BATCH_PREDICT));
        }
    }

    public static class Builder {
        private ActionType actionType;
        private String method;
        private String url;
        private Map<String, String> headers;
        private String requestBody;
        private String preProcessFunction;
        private String postProcessFunction;

        public Builder actionType(ActionType actionType) {
            if (actionType == null) {
                throw new IllegalArgumentException("action type can't be null");
            }
            this.actionType = actionType;
            return this;
        }

        public Builder url(String url) {
            if (url == null) {
                throw new IllegalArgumentException("url can't be null");
            }
            this.url = url;
            return this;
        }

        public Builder method(String method) {
            if (method == null) {
                throw new IllegalArgumentException("method can't be null");
            }
            this.method = method;
            return this;
        }

        public Builder headers(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public Builder requestBody(String requestBody) {
            this.requestBody = requestBody;
            return this;
        }

        public Builder preProcessFunction(String preProcessFunction) {
            this.preProcessFunction = preProcessFunction;
            return this;
        }

        public Builder postProcessFunction(String postProcessFunction) {
            this.postProcessFunction = postProcessFunction;
            return this;
        }

        public ConnectorAction build() {
            return new ConnectorAction(this.actionType, this.method, this.url, this.headers, this.requestBody, this.preProcessFunction, this.postProcessFunction);
        }
    }
}

