/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.connector;

import io.skylite.Version;
import io.skylite.core.common.Strings;
import io.skylite.core.common.io.stream.BytesStreamOutput;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.security.auth.User;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.ml.common.AccessMode;
import io.skylite.ml.common.CommonValue;
import io.skylite.ml.common.connector.AbstractConnector;
import io.skylite.ml.common.connector.Connector;
import io.skylite.ml.common.connector.ConnectorAction;
import io.skylite.ml.common.connector.ConnectorClientConfig;
import io.skylite.ml.common.connector.ConnectorProtocols;
import io.skylite.ml.common.transport.connector.MLCreateConnectorInput;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.text.StringSubstitutor;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.InputStreamEntity;
import org.apache.hc.core5.http.io.support.ClassicRequestBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@io.skylite.ml.common.annotation.Connector(value="http")
public class HttpConnector
extends AbstractConnector {
    private static final Logger log = LogManager.getLogger(HttpConnector.class);
    public static final String CREDENTIAL_FIELD = "credential";
    public static final String RESPONSE_FILTER_FIELD = "response_filter";
    public static final String PARAMETERS_FIELD = "parameters";
    public static final String SERVICE_NAME_FIELD = "service_name";
    public static final String REGION_FIELD = "region";

    public HttpConnector() {
    }

    public HttpConnector(String name, String description, String version, String protocol, Map<String, String> parameters, Map<String, String> credential, List<ConnectorAction> actions, List<String> backendRoles, AccessMode accessMode, User owner, ConnectorClientConfig connectorClientConfig, String tenantId) {
        ConnectorProtocols.validateProtocol(protocol);
        this.name = name;
        this.description = description;
        this.version = version;
        this.protocol = protocol;
        this.parameters = parameters;
        this.credential = credential;
        this.actions = actions;
        this.backendRoles = backendRoles;
        this.access = accessMode;
        this.owner = owner;
        this.connectorClientConfig = connectorClientConfig;
        this.tenantId = tenantId;
    }

    public HttpConnector(String protocol, XContentParser parser) throws IOException {
        this.protocol = protocol;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block32: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "name": {
                    this.name = parser.text();
                    continue block32;
                }
                case "version": {
                    this.version = parser.text();
                    continue block32;
                }
                case "description": {
                    this.description = parser.text();
                    continue block32;
                }
                case "protocol": {
                    this.protocol = parser.text();
                    continue block32;
                }
                case "parameters": {
                    Map map = parser.map();
                    this.parameters = Strings.getParameterMap((Map)map);
                    continue block32;
                }
                case "credential": {
                    this.credential = new HashMap();
                    this.credential.putAll(parser.mapStrings());
                    continue block32;
                }
                case "actions": {
                    this.actions = new ArrayList();
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        this.actions.add(ConnectorAction.parse(parser));
                    }
                    continue block32;
                }
                case "backend_roles": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    this.backendRoles = new ArrayList();
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        this.backendRoles.add(parser.text());
                    }
                    continue block32;
                }
                case "owner": {
                    this.owner = User.parse((XContentParser)parser);
                    continue block32;
                }
                case "access": {
                    this.access = AccessMode.from(parser.text());
                    continue block32;
                }
                case "created_time": {
                    this.createdTime = Instant.ofEpochMilli(parser.longValue());
                    continue block32;
                }
                case "last_updated_time": {
                    this.lastUpdateTime = Instant.ofEpochMilli(parser.longValue());
                    continue block32;
                }
                case "client_config": {
                    this.connectorClientConfig = ConnectorClientConfig.parse(parser);
                    continue block32;
                }
                case "tenant_id": {
                    this.tenantId = parser.textOrNull();
                    continue block32;
                }
            }
            parser.skipChildren();
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.name != null) {
            builder.field("name", this.name);
        }
        if (this.version != null) {
            builder.field("version", this.version);
        }
        if (this.description != null) {
            builder.field("description", this.description);
        }
        if (this.protocol != null) {
            builder.field("protocol", this.protocol);
        }
        if (this.parameters != null) {
            builder.field(PARAMETERS_FIELD, (Object)this.parameters);
        }
        if (this.credential != null) {
            builder.field(CREDENTIAL_FIELD, (Object)this.credential);
        }
        if (this.actions != null) {
            builder.field("actions", (Iterable)this.actions);
        }
        if (this.backendRoles != null) {
            builder.field("backend_roles", (Iterable)this.backendRoles);
        }
        if (this.owner != null) {
            builder.field("owner", (ToXContent)this.owner);
        }
        if (this.access != null) {
            builder.field("access", this.access.getValue());
        }
        if (this.createdTime != null) {
            builder.field("created_time", this.createdTime.toEpochMilli());
        }
        if (this.lastUpdateTime != null) {
            builder.field("last_updated_time", this.lastUpdateTime.toEpochMilli());
        }
        if (this.connectorClientConfig != null) {
            builder.field("client_config", (ToXContent)this.connectorClientConfig);
        }
        if (this.tenantId != null) {
            builder.field("tenant_id", this.tenantId);
        }
        builder.endObject();
        return builder;
    }

    public HttpConnector(String protocol, StreamInput input) throws IOException {
        this.protocol = protocol;
        this.parseFromStream(input);
    }

    public HttpConnector(StreamInput input) throws IOException {
        this.protocol = input.readString();
        this.parseFromStream(input);
    }

    private void parseFromStream(StreamInput input) throws IOException {
        Version streamInputVersion = input.getVersion();
        this.name = input.readOptionalString();
        this.version = input.readOptionalString();
        this.description = input.readOptionalString();
        if (input.readBoolean()) {
            this.parameters = input.readMap(StreamInput::readString, StreamInput::readString);
        }
        if (input.readBoolean()) {
            this.credential = input.readMap(StreamInput::readString, StreamInput::readString);
        }
        if (input.readBoolean()) {
            this.actions = new ArrayList();
            int size = input.readInt();
            for (int i = 0; i < size; ++i) {
                this.actions.add(new ConnectorAction(input));
            }
        }
        this.backendRoles = input.readOptionalStringList();
        if (input.readBoolean()) {
            this.access = (AccessMode)input.readEnum(AccessMode.class);
        }
        if (input.readBoolean()) {
            this.owner = new User(input);
        }
        this.createdTime = input.readOptionalInstant();
        this.lastUpdateTime = input.readOptionalInstant();
        if (input.readBoolean()) {
            this.connectorClientConfig = new ConnectorClientConfig(input);
        }
        this.tenantId = streamInputVersion.onOrAfter((Version)CommonValue.VERSION_2_19_0) ? input.readOptionalString() : null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        Version streamOutputVersion = out.getVersion();
        out.writeString(this.protocol);
        out.writeOptionalString(this.name);
        out.writeOptionalString(this.version);
        out.writeOptionalString(this.description);
        if (this.parameters != null) {
            out.writeBoolean(true);
            out.writeMap(this.parameters, StreamOutput::writeString, StreamOutput::writeString);
        } else {
            out.writeBoolean(false);
        }
        if (this.credential != null) {
            out.writeBoolean(true);
            out.writeMap(this.credential, StreamOutput::writeString, StreamOutput::writeString);
        } else {
            out.writeBoolean(false);
        }
        if (this.actions != null) {
            out.writeBoolean(true);
            out.writeInt(this.actions.size());
            for (ConnectorAction action : this.actions) {
                action.writeTo(out);
            }
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalStringCollection((Collection)this.backendRoles);
        if (this.access != null) {
            out.writeBoolean(true);
            out.writeEnum((Enum)this.access);
        } else {
            out.writeBoolean(false);
        }
        if (this.owner != null) {
            out.writeBoolean(true);
            this.owner.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalInstant(this.createdTime);
        out.writeOptionalInstant(this.lastUpdateTime);
        if (this.connectorClientConfig != null) {
            out.writeBoolean(true);
            this.connectorClientConfig.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        if (streamOutputVersion.onOrAfter((Version)CommonValue.VERSION_2_19_0)) {
            out.writeOptionalString(this.tenantId);
        }
    }

    @Override
    public void update(MLCreateConnectorInput updateContent, BiFunction<String, String, String> function) {
        if (updateContent.getName() != null) {
            this.name = updateContent.getName();
        }
        if (updateContent.getDescription() != null) {
            this.description = updateContent.getDescription();
        }
        if (updateContent.getVersion() != null) {
            this.version = updateContent.getVersion();
        }
        if (updateContent.getProtocol() != null) {
            this.protocol = updateContent.getProtocol();
        }
        if (updateContent.getParameters() != null && !updateContent.getParameters().isEmpty()) {
            this.getParameters().putAll(updateContent.getParameters());
        }
        if (updateContent.getCredential() != null && !updateContent.getCredential().isEmpty()) {
            this.credential = updateContent.getCredential();
            this.encrypt(function, this.tenantId);
        }
        if (updateContent.getActions() != null) {
            this.actions = updateContent.getActions();
        }
        if (updateContent.getBackendRoles() != null) {
            this.backendRoles = updateContent.getBackendRoles();
        }
        if (updateContent.getAccess() != null) {
            this.access = updateContent.getAccess();
        }
        if (updateContent.getConnectorClientConfig() != null) {
            this.connectorClientConfig = updateContent.getConnectorClientConfig();
        }
    }

    public ClassicHttpRequest buildSdkRequest(String action, Map<String, String> parameters, String payload, RestRequest.Method method) {
        String charset = parameters.getOrDefault("charset", "UTF-8");
        Charset cs = Charset.forName(charset);
        ContentType contentType = ContentType.create((String)"text/plain", (Charset)cs);
        URI endpoint = URI.create(this.getActionEndpoint(action, parameters));
        ClassicRequestBuilder requestBuilder = ClassicRequestBuilder.create((String)method.name()).setUri(endpoint);
        if (payload != null && !payload.isEmpty()) {
            ByteArrayInputStream payloadStream = new ByteArrayInputStream(payload.getBytes(cs));
            InputStreamEntity entity = new InputStreamEntity((InputStream)payloadStream, -1L, contentType);
            requestBuilder.setEntity((HttpEntity)entity);
        }
        return requestBuilder.build();
    }

    @Override
    public <T> T createPayload(String action, Map<String, String> parameters) {
        Optional<ConnectorAction> connectorAction = this.findAction(action);
        if (connectorAction.isPresent() && connectorAction.get().getRequestBody() != null) {
            String payload = connectorAction.get().getRequestBody();
            payload = this.fillNullParameters(parameters, payload);
            Strings.parseParameters(parameters);
            StringSubstitutor substitutor = new StringSubstitutor(parameters, "${parameters.", "}");
            payload = substitutor.replace(payload);
            if (!Strings.isJson((String)payload)) {
                throw new IllegalArgumentException("Invalid payload: " + payload);
            }
            return (T)payload;
        }
        return (T)parameters.get("http_body");
    }

    protected String fillNullParameters(Map<String, String> parameters, String payload) {
        List<String> bodyParams = this.findStringParametersWithNullDefaultValue(payload);
        String newPayload = payload;
        for (String key : bodyParams) {
            if (parameters.containsKey(key) && parameters.get(key) != null) continue;
            newPayload = newPayload.replace("\"${parameters." + key + ":-null}\"", "null");
        }
        return newPayload;
    }

    private List<String> findStringParametersWithNullDefaultValue(String input) {
        String regex = "\"\\$\\{parameters\\.(\\w+):-null}\"";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(input);
        ArrayList<String> paramList = new ArrayList<String>();
        while (matcher.find()) {
            String parameterValue = matcher.group(1);
            paramList.add(parameterValue);
        }
        return paramList;
    }

    @Override
    public void decrypt(String action, BiFunction<String, String, String> function, String tenantId) {
        HashMap<String, String> decrypted = new HashMap<String, String>();
        for (String key : this.credential.keySet()) {
            decrypted.put(key, function.apply((String)this.credential.get(key), tenantId));
        }
        this.decryptedCredential = decrypted;
        Optional<ConnectorAction> connectorAction = this.findAction(action);
        Map headers = connectorAction.map(ConnectorAction::getHeaders).orElse(null);
        this.decryptedHeaders = this.createDecryptedHeaders(headers);
    }

    @Override
    public Connector cloneConnector() {
        HttpConnector httpConnector;
        BytesStreamOutput bytesStreamOutput = new BytesStreamOutput();
        try {
            this.writeTo((StreamOutput)bytesStreamOutput);
            StreamInput streamInput = bytesStreamOutput.bytes().streamInput();
            httpConnector = new HttpConnector(streamInput);
        }
        catch (Throwable throwable) {
            try {
                try {
                    bytesStreamOutput.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        bytesStreamOutput.close();
        return httpConnector;
    }

    @Override
    public void encrypt(BiFunction<String, String, String> function, String tenantId) {
        for (String key : this.credential.keySet()) {
            String encrypted = function.apply((String)this.credential.get(key), tenantId);
            this.credential.put(key, encrypted);
        }
    }

    @Override
    public String getActionHttpMethod(String action) {
        return this.findAction(action).get().getMethod();
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String name;
        private String description;
        private String version;
        private String protocol;
        private Map<String, String> parameters;
        private Map<String, String> credential;
        private List<ConnectorAction> actions;
        private List<String> backendRoles;
        private AccessMode accessMode;
        private User owner;
        private ConnectorClientConfig connectorClientConfig;
        private String tenantId;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder parameters(Map<String, String> parameters) {
            this.parameters = parameters;
            return this;
        }

        public Builder credential(Map<String, String> credential) {
            this.credential = credential;
            return this;
        }

        public Builder actions(List<ConnectorAction> actions) {
            this.actions = actions;
            return this;
        }

        public Builder backendRoles(List<String> backendRoles) {
            this.backendRoles = backendRoles;
            return this;
        }

        public Builder accessMode(AccessMode accessMode) {
            this.accessMode = accessMode;
            return this;
        }

        public Builder owner(User owner) {
            this.owner = owner;
            return this;
        }

        public Builder connectorClientConfig(ConnectorClientConfig connectorClientConfig) {
            this.connectorClientConfig = connectorClientConfig;
            return this;
        }

        public Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public HttpConnector build() {
            return new HttpConnector(this.name, this.description, this.version, this.protocol, this.parameters, this.credential, this.actions, this.backendRoles, this.accessMode, this.owner, this.connectorClientConfig, this.tenantId);
        }
    }
}

