/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.connector.functions.preprocess;

import io.skylite.ml.common.connector.functions.preprocess.ConnectorPreProcessFunction;
import io.skylite.ml.common.dataset.TextSimilarityInputDataSet;
import io.skylite.ml.common.dataset.remote.RemoteInferenceInputDataSet;
import io.skylite.ml.common.input.MLInput;
import java.util.Map;

public class CohereRerankPreProcessFunction
extends ConnectorPreProcessFunction {
    public CohereRerankPreProcessFunction() {
        this.returnDirectlyForRemoteInferenceInput = true;
    }

    @Override
    public void validate(MLInput mlInput) {
        if (!(mlInput.getInputDataset() instanceof TextSimilarityInputDataSet)) {
            throw new IllegalArgumentException("This pre_process_function can only support TextSimilarityInputDataSet");
        }
    }

    @Override
    public RemoteInferenceInputDataSet process(MLInput mlInput) {
        TextSimilarityInputDataSet inputData = (TextSimilarityInputDataSet)mlInput.getInputDataset();
        Map<String, Object> processedResult = Map.of("parameters", Map.of("query", inputData.getQueryText(), "documents", inputData.getTextDocs(), "top_n", inputData.getTextDocs().size()));
        return RemoteInferenceInputDataSet.builder().parameters(CohereRerankPreProcessFunction.convertScriptStringToJsonString(processedResult)).build();
    }
}

