/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.connector.functions.preprocess;

import io.skylite.core.common.Strings;
import io.skylite.core.script.ScriptService;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.ml.common.connector.functions.preprocess.ConnectorPreProcessFunction;
import io.skylite.ml.common.dataset.remote.RemoteInferenceInputDataSet;
import io.skylite.ml.common.input.MLInput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class DefaultPreProcessFunction
extends ConnectorPreProcessFunction {
    private final ScriptService scriptService;
    private final String preProcessFunction;
    private final boolean convertInputToJsonString;

    public DefaultPreProcessFunction(ScriptService scriptService, String preProcessFunction, boolean convertInputToJsonString) {
        this.returnDirectlyForRemoteInferenceInput = false;
        this.scriptService = scriptService;
        this.preProcessFunction = preProcessFunction;
        this.convertInputToJsonString = convertInputToJsonString;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void validate(MLInput mlInput) {
    }

    @Override
    public RemoteInferenceInputDataSet process(MLInput mlInput) {
        RemoteInferenceInputDataSet remoteInferenceInputDataSet;
        block10: {
            XContentBuilder builder = MediaTypeRegistry.JSON.contentBuilder();
            try {
                String processedInput;
                mlInput.toXContent(builder, ToXContent.EMPTY_PARAMS);
                String inputStr = builder.toString();
                Map<String, Object> inputParams = (Map<String, Object>)Strings.fromJson((String)inputStr, HashMap.class);
                if (this.convertInputToJsonString) {
                    inputParams = DefaultPreProcessFunction.convertScriptStringToJsonString(Map.of("parameters", Strings.fromJson((String)inputStr, Map.class)));
                }
                if ((processedInput = this.executeScript(this.scriptService, this.preProcessFunction, inputParams)) == null) {
                    throw new IllegalArgumentException("Preprocess function output is null");
                }
                Map map = (Map)Strings.fromJson((String)processedInput, Map.class);
                remoteInferenceInputDataSet = RemoteInferenceInputDataSet.builder().parameters(DefaultPreProcessFunction.convertScriptStringToJsonString(map)).build();
                if (builder == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (builder != null) {
                        try {
                            builder.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Failed to run pre-process function: Wrong input");
                }
            }
            builder.close();
        }
        return remoteInferenceInputDataSet;
    }

    public static class Builder {
        private ScriptService scriptService;
        private String preProcessFunction;
        private boolean convertInputToJsonString;

        public Builder scriptService(ScriptService scriptService) {
            this.scriptService = scriptService;
            return this;
        }

        public Builder preProcessFunction(String preProcessFunction) {
            this.preProcessFunction = preProcessFunction;
            return this;
        }

        public Builder convertInputToJsonString(boolean convertInputToJsonString) {
            this.convertInputToJsonString = convertInputToJsonString;
            return this;
        }

        public DefaultPreProcessFunction build() {
            return new DefaultPreProcessFunction(this.scriptService, this.preProcessFunction, this.convertInputToJsonString);
        }
    }
}

