/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.connector.functions.preprocess;

import io.skylite.ml.common.connector.functions.preprocess.ConnectorPreProcessFunction;
import io.skylite.ml.common.dataset.TextDocsInputDataSet;
import io.skylite.ml.common.dataset.remote.RemoteInferenceInputDataSet;
import io.skylite.ml.common.input.MLInput;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MultiModalConnectorPreProcessFunction
extends ConnectorPreProcessFunction {
    public MultiModalConnectorPreProcessFunction() {
        this.returnDirectlyForRemoteInferenceInput = true;
    }

    @Override
    public void validate(MLInput mlInput) {
        this.validateTextDocsInput(mlInput);
        List<String> docs = ((TextDocsInputDataSet)mlInput.getInputDataset()).getDocs();
        if (docs.size() == 0 || docs.size() == 1 && docs.get(0) == null) {
            throw new IllegalArgumentException("No input text or image provided");
        }
    }

    @Override
    public RemoteInferenceInputDataSet process(MLInput mlInput) {
        TextDocsInputDataSet inputData = (TextDocsInputDataSet)mlInput.getInputDataset();
        HashMap<String, String> parametersMap = new HashMap<String, String>();
        parametersMap.put("inputText", inputData.getDocs().get(0));
        if (inputData.getDocs().size() > 1) {
            parametersMap.put("inputImage", inputData.getDocs().get(1));
        }
        return RemoteInferenceInputDataSet.builder().parameters(MultiModalConnectorPreProcessFunction.convertScriptStringToJsonString(Map.of("parameters", parametersMap))).build();
    }
}

