/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.controller;

import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.ml.common.controller.MLRateLimiter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class MLController
implements ToXContentObject,
Writeable {
    public static final String MODEL_ID_FIELD = "model_id";
    public static final String USER_RATE_LIMITER = "user_rate_limiter";
    private String modelId;
    private Map<String, MLRateLimiter> userRateLimiter;

    public MLController(String modelId, Map<String, MLRateLimiter> userRateLimiter) {
        this.modelId = modelId;
        this.userRateLimiter = userRateLimiter;
    }

    public static MLController parse(XContentParser parser) throws IOException {
        String modelId = null;
        HashMap<String, MLRateLimiter> userRateLimiter = new HashMap<String, MLRateLimiter>();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block8: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "model_id": {
                    modelId = parser.text();
                    break;
                }
                case "user_rate_limiter": {
                    if (parser.currentToken() == XContentParser.Token.VALUE_NULL) break;
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                        String userName = parser.currentName();
                        parser.nextToken();
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                        MLRateLimiter rateLimiter = MLRateLimiter.parse(parser);
                        if (rateLimiter.isEmpty()) continue;
                        userRateLimiter.put(userName, rateLimiter);
                    }
                    continue block8;
                }
                default: {
                    parser.skipChildren();
                }
            }
        }
        return new MLController(modelId, userRateLimiter);
    }

    public MLController(StreamInput in) throws IOException {
        this.modelId = in.readString();
        if (in.readBoolean()) {
            this.userRateLimiter = in.readMap(StreamInput::readString, MLRateLimiter::new);
        }
    }

    public String getModelId() {
        return this.modelId;
    }

    public Map<String, MLRateLimiter> getUserRateLimiter() {
        return this.userRateLimiter;
    }

    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    public void setUserRateLimiter(Map<String, MLRateLimiter> userRateLimiter) {
        this.userRateLimiter = userRateLimiter;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().modelId(this.modelId).userRateLimiter(this.userRateLimiter);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.modelId);
        if (this.userRateLimiter != null) {
            out.writeBoolean(true);
            out.writeMap(this.userRateLimiter, StreamOutput::writeString, (streamOutput, rateLimiter) -> rateLimiter.writeTo(streamOutput));
        } else {
            out.writeBoolean(false);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(MODEL_ID_FIELD, this.modelId);
        if (this.userRateLimiter != null) {
            builder.field(USER_RATE_LIMITER, this.userRateLimiter);
        }
        builder.endObject();
        return builder;
    }

    public boolean isDeployRequiredAfterUpdate(MLController updateContent) {
        if (updateContent != null && updateContent.getUserRateLimiter() != null && !updateContent.getUserRateLimiter().isEmpty()) {
            Map<String, MLRateLimiter> updateUserRateLimiter = updateContent.getUserRateLimiter();
            for (Map.Entry<String, MLRateLimiter> entry : updateUserRateLimiter.entrySet()) {
                MLRateLimiter oldRateLimiter;
                String newUser = entry.getKey();
                MLRateLimiter newRateLimiter = entry.getValue();
                if (!(this.userRateLimiter.containsKey(newUser) ? MLRateLimiter.isDeployRequiredAfterUpdate(oldRateLimiter = this.userRateLimiter.get(newUser), newRateLimiter) : newRateLimiter.isValid())) continue;
                return true;
            }
        }
        return false;
    }

    public void update(MLController updateContent) {
        Map<String, MLRateLimiter> updateUserRateLimiter = updateContent.getUserRateLimiter();
        if (updateUserRateLimiter != null && !updateUserRateLimiter.isEmpty()) {
            updateUserRateLimiter.forEach((user, rateLimiter) -> {
                if (this.userRateLimiter.containsKey(user)) {
                    this.userRateLimiter.get(user).update((MLRateLimiter)rateLimiter);
                } else {
                    this.userRateLimiter.put((String)user, (MLRateLimiter)rateLimiter);
                }
            });
        }
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MLController that = (MLController)o;
        return Objects.equals(this.modelId, that.modelId) && Objects.equals(this.userRateLimiter, that.userRateLimiter);
    }

    public int hashCode() {
        return Objects.hash(this.modelId, this.userRateLimiter);
    }

    public String toString() {
        return "MLController{modelId='" + this.modelId + "', userRateLimiter=" + String.valueOf(this.userRateLimiter) + "}";
    }

    public static class Builder {
        private String modelId;
        private Map<String, MLRateLimiter> userRateLimiter;

        public Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public Builder userRateLimiter(Map<String, MLRateLimiter> userRateLimiter) {
            this.userRateLimiter = userRateLimiter;
            return this;
        }

        public MLController build() {
            return new MLController(this.modelId, this.userRateLimiter);
        }
    }
}

