/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.dataframe;

import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.ml.common.dataframe.ColumnType;
import java.io.IOException;
import java.util.Locale;

public class ColumnMeta
implements Writeable,
ToXContentObject {
    private static final String NAME_FIELD = "name";
    private static final String COLUMN_TYPE_FIELD = "column_type";
    private final String name;
    private final ColumnType columnType;

    public ColumnMeta(String name, ColumnType columnType) {
        this.name = name;
        this.columnType = columnType;
    }

    ColumnMeta(StreamInput in) throws IOException {
        this.name = in.readOptionalString();
        this.columnType = (ColumnType)in.readEnum(ColumnType.class);
    }

    public String getName() {
        return this.name;
    }

    public static ColumnMeta parse(XContentParser parser) throws IOException {
        String name = null;
        ColumnType columnType = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block8: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "name": {
                    name = parser.text();
                    continue block8;
                }
                case "column_type": {
                    columnType = ColumnType.valueOf(parser.text().toUpperCase(Locale.ROOT));
                    continue block8;
                }
            }
            parser.skipChildren();
        }
        return new ColumnMeta(name, columnType);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.name);
        out.writeEnum((Enum)this.columnType);
    }

    public void toXContent(XContentBuilder builder) throws IOException {
        this.toXContent(builder, EMPTY_PARAMS);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(NAME_FIELD, this.name);
        builder.field(COLUMN_TYPE_FIELD, (Object)this.columnType);
        builder.endObject();
        return builder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "ColumnMeta{name='" + this.name + "', columnType=" + String.valueOf((Object)this.columnType) + "}";
    }

    public ColumnType getColumnType() {
        return this.columnType;
    }

    public static class Builder {
        private String name;
        private ColumnType columnType;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder columnType(ColumnType columnType) {
            this.columnType = columnType;
            return this;
        }

        public ColumnMeta build() {
            return new ColumnMeta(this.name, this.columnType);
        }
    }
}

