/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.dataframe;

import io.skylite.ml.common.dataframe.BooleanValue;
import io.skylite.ml.common.dataframe.ColumnValue;
import io.skylite.ml.common.dataframe.DoubleValue;
import io.skylite.ml.common.dataframe.FloatValue;
import io.skylite.ml.common.dataframe.IntValue;
import io.skylite.ml.common.dataframe.LongValue;
import io.skylite.ml.common.dataframe.NullValue;
import io.skylite.ml.common.dataframe.ShortValue;
import io.skylite.ml.common.dataframe.StringValue;
import java.util.Objects;

public final class ColumnValueBuilder {
    private ColumnValueBuilder() {
    }

    public static ColumnValue build(Object object) {
        if (Objects.isNull(object)) {
            return new NullValue();
        }
        if (object instanceof Short) {
            return new ShortValue((Short)object);
        }
        if (object instanceof Integer) {
            return new IntValue((Integer)object);
        }
        if (object instanceof Long) {
            return new LongValue((Long)object);
        }
        if (object instanceof String) {
            return new StringValue((String)object);
        }
        if (object instanceof Double) {
            return new DoubleValue((Double)object);
        }
        if (object instanceof Boolean) {
            return new BooleanValue((Boolean)object);
        }
        if (object instanceof Float) {
            return new FloatValue(((Float)object).floatValue());
        }
        throw new IllegalArgumentException("unsupported type:" + object.getClass().getName());
    }
}

