/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.dataframe;

import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.ml.common.dataframe.BooleanValue;
import io.skylite.ml.common.dataframe.ColumnType;
import io.skylite.ml.common.dataframe.ColumnValue;
import io.skylite.ml.common.dataframe.DoubleValue;
import io.skylite.ml.common.dataframe.FloatValue;
import io.skylite.ml.common.dataframe.IntValue;
import io.skylite.ml.common.dataframe.LongValue;
import io.skylite.ml.common.dataframe.NullValue;
import io.skylite.ml.common.dataframe.ShortValue;
import io.skylite.ml.common.dataframe.StringValue;
import java.io.IOException;

public class ColumnValueReader
implements Writeable.Reader<ColumnValue> {
    public ColumnValue read(StreamInput in) throws IOException {
        ColumnType columnType = (ColumnType)in.readEnum(ColumnType.class);
        switch (columnType) {
            case SHORT: {
                return new ShortValue(in.readShort());
            }
            case INTEGER: {
                return new IntValue(in.readInt());
            }
            case LONG: {
                return new LongValue(in.readLong());
            }
            case DOUBLE: {
                return new DoubleValue(in.readDouble());
            }
            case STRING: {
                return new StringValue(in.readString());
            }
            case BOOLEAN: {
                return new BooleanValue(in.readBoolean());
            }
            case FLOAT: {
                return new FloatValue(in.readFloat());
            }
            case NULL: {
                return new NullValue();
            }
        }
        throw new IllegalArgumentException("unknown type:" + String.valueOf((Object)columnType));
    }
}

