/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.dataframe;

import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.ml.common.dataframe.ColumnType;
import io.skylite.ml.common.dataframe.ColumnValue;
import java.io.IOException;

public class ShortValue
implements ColumnValue {
    private final short value;

    public ShortValue(short value) {
        this.value = value;
    }

    @Override
    public ColumnType columnType() {
        return ColumnType.SHORT;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public short shortValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return Short.valueOf(this.value).doubleValue();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnum((Enum)this.columnType());
        out.writeShort(this.value);
    }

    public String toString() {
        return "ShortValue{value=" + this.value + "}";
    }
}

