/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.dataset;

import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.ml.common.annotation.InputDataSet;
import io.skylite.ml.common.dataset.MLInputDataType;
import io.skylite.ml.common.dataset.MLInputDataset;
import java.io.IOException;

@InputDataSet(value=MLInputDataType.QUESTION_ANSWERING)
public class QuestionAnsweringInputDataSet
extends MLInputDataset {
    private final String question;
    private final String context;

    public QuestionAnsweringInputDataSet(String question, String context) {
        super(MLInputDataType.QUESTION_ANSWERING);
        if (question == null) {
            throw new IllegalArgumentException("Question is not provided");
        }
        if (context == null) {
            throw new IllegalArgumentException("Context is not provided");
        }
        this.question = question;
        this.context = context;
    }

    public QuestionAnsweringInputDataSet(StreamInput in) throws IOException {
        super(MLInputDataType.QUESTION_ANSWERING);
        this.question = in.readString();
        this.context = in.readString();
    }

    public String getQuestion() {
        return this.question;
    }

    public String getContext() {
        return this.context;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.question);
        out.writeString(this.context);
    }

    public static Builder builder() {
        return new Builder();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder;
    }

    public static class Builder {
        private String question;
        private String context;

        public Builder question(String question) {
            this.question = question;
            return this;
        }

        public Builder context(String context) {
            this.context = context;
            return this;
        }

        public QuestionAnsweringInputDataSet build() {
            return new QuestionAnsweringInputDataSet(this.question, this.context);
        }
    }
}

