/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.dataset;

import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.ml.common.annotation.InputDataSet;
import io.skylite.ml.common.dataset.MLInputDataType;
import io.skylite.ml.common.dataset.MLInputDataset;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@InputDataSet(value=MLInputDataType.TEXT_SIMILARITY)
public class TextSimilarityInputDataSet
extends MLInputDataset {
    private final List<String> textDocs;
    private final String queryText;

    public TextSimilarityInputDataSet(String queryText, List<String> textDocs) {
        super(MLInputDataType.TEXT_SIMILARITY);
        Objects.requireNonNull(textDocs);
        Objects.requireNonNull(queryText);
        if (textDocs.isEmpty()) {
            throw new IllegalArgumentException("No text documents were provided");
        }
        this.textDocs = textDocs;
        this.queryText = queryText;
    }

    public TextSimilarityInputDataSet(StreamInput in) throws IOException {
        super(MLInputDataType.TEXT_SIMILARITY);
        this.queryText = in.readString();
        int size = in.readInt();
        this.textDocs = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            String context = in.readString();
            this.textDocs.add(context);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.queryText);
        out.writeInt(this.textDocs.size());
        for (String doc : this.textDocs) {
            out.writeString(doc);
        }
    }

    public List<String> getTextDocs() {
        return this.textDocs;
    }

    public String getQueryText() {
        return this.queryText;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder;
    }

    public static class Builder {
        private List<String> textDocs;
        private String queryText;

        Builder() {
        }

        Builder(TextSimilarityInputDataSet input) {
            this.textDocs = input.textDocs;
            this.queryText = input.queryText;
        }

        public Builder textDocs(List<String> textDocs) {
            this.textDocs = textDocs;
            return this;
        }

        public Builder queryText(String queryText) {
            this.queryText = queryText;
            return this;
        }

        public TextSimilarityInputDataSet build() {
            return new TextSimilarityInputDataSet(this.queryText, this.textDocs);
        }
    }
}

