/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.dataset.remote;

import io.skylite.Version;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.ml.common.CommonValue;
import io.skylite.ml.common.annotation.InputDataSet;
import io.skylite.ml.common.connector.ConnectorAction;
import io.skylite.ml.common.dataset.MLInputDataType;
import io.skylite.ml.common.dataset.MLInputDataset;
import java.io.IOException;
import java.util.Map;

@InputDataSet(value=MLInputDataType.REMOTE)
public class RemoteInferenceInputDataSet
extends MLInputDataset {
    private static final Version MINIMAL_SUPPORTED_VERSION_FOR_CLIENT_CONFIG = CommonValue.VERSION_2_16_0;
    private static final Version MINIMAL_SUPPORTED_VERSION_FOR_DLQ_CONFIG = CommonValue.VERSION_2_19_0;
    private Map<String, String> parameters;
    private ConnectorAction.ActionType actionType;
    private Map<String, String> dlq;

    public RemoteInferenceInputDataSet(Map<String, String> parameters, ConnectorAction.ActionType actionType, Map<String, String> dlq) {
        super(MLInputDataType.REMOTE);
        this.parameters = parameters;
        this.actionType = actionType;
        this.dlq = dlq;
    }

    public RemoteInferenceInputDataSet(Map<String, String> parameters, ConnectorAction.ActionType actionType) {
        this(parameters, actionType, null);
    }

    public RemoteInferenceInputDataSet(Map<String, String> parameters) {
        this(parameters, null, null);
    }

    public RemoteInferenceInputDataSet(StreamInput streamInput) throws IOException {
        super(MLInputDataType.REMOTE);
        Version streamInputVersion = streamInput.getVersion();
        if (streamInput.readBoolean()) {
            this.parameters = streamInput.readMap(StreamInput::readString, StreamInput::readString);
        }
        if (streamInputVersion.onOrAfter(MINIMAL_SUPPORTED_VERSION_FOR_CLIENT_CONFIG)) {
            this.actionType = streamInput.readBoolean() ? (ConnectorAction.ActionType)streamInput.readEnum(ConnectorAction.ActionType.class) : null;
        }
        if (streamInputVersion.onOrAfter(MINIMAL_SUPPORTED_VERSION_FOR_DLQ_CONFIG)) {
            this.dlq = streamInput.readBoolean() ? streamInput.readMap(s -> s.readString(), s -> s.readString()) : null;
        }
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public void setActionType(ConnectorAction.ActionType actionType) {
        this.actionType = actionType;
    }

    public void setDlq(Map<String, String> dlq) {
        this.dlq = dlq;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public ConnectorAction.ActionType getActionType() {
        return this.actionType;
    }

    public Map<String, String> getDlq() {
        return this.dlq;
    }

    @Override
    public void writeTo(StreamOutput streamOutput) throws IOException {
        super.writeTo(streamOutput);
        Version streamOutputVersion = streamOutput.getVersion();
        if (this.parameters != null) {
            streamOutput.writeBoolean(true);
            streamOutput.writeMap(this.parameters, StreamOutput::writeString, StreamOutput::writeString);
        } else {
            streamOutput.writeBoolean(false);
        }
        if (streamOutputVersion.onOrAfter(MINIMAL_SUPPORTED_VERSION_FOR_CLIENT_CONFIG)) {
            if (this.actionType != null) {
                streamOutput.writeBoolean(true);
                streamOutput.writeEnum((Enum)this.actionType);
            } else {
                streamOutput.writeBoolean(false);
            }
        }
        if (streamOutputVersion.onOrAfter(MINIMAL_SUPPORTED_VERSION_FOR_DLQ_CONFIG)) {
            if (this.dlq != null) {
                streamOutput.writeBoolean(true);
                streamOutput.writeMap(this.dlq, StreamOutput::writeString, StreamOutput::writeString);
            } else {
                streamOutput.writeBoolean(false);
            }
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder;
    }

    public static class Builder {
        private Map<String, String> parameters;
        private ConnectorAction.ActionType actionType;
        private Map<String, String> dlq;

        public Builder parameters(Map<String, String> parameters) {
            this.parameters = parameters;
            return this;
        }

        public Builder actionType(ConnectorAction.ActionType actionType) {
            this.actionType = actionType;
            return this;
        }

        public Builder dlq(Map<String, String> dlq) {
            this.dlq = dlq;
            return this;
        }

        public RemoteInferenceInputDataSet build() {
            return new RemoteInferenceInputDataSet(this.parameters, this.actionType, this.dlq);
        }
    }
}

