/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.engine.memory;

import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.ml.common.engine.memory.BaseMessage;
import java.io.IOException;
import java.time.Instant;
import java.util.Objects;

public class ConversationIndexMessage
extends BaseMessage {
    private String sessionId;
    private String question;
    private String response;
    private Boolean finalAnswer;
    private Instant createdTime;

    public ConversationIndexMessage(String type, String sessionId, String question, String response, boolean finalAnswer) {
        super(type, response);
        this.sessionId = sessionId;
        this.question = question;
        this.response = response;
        this.finalAnswer = finalAnswer;
        this.createdTime = Instant.now();
    }

    @Override
    public String toString() {
        return "Human:" + this.question + "\nAssistant:" + this.response;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.sessionId != null) {
            builder.field("session_id", this.sessionId);
        }
        if (this.question != null) {
            builder.field("question", this.question);
        }
        if (this.response != null) {
            builder.field("response", this.response);
        }
        if (this.finalAnswer != null) {
            builder.field("final_answer", this.finalAnswer);
        }
        builder.field("created_time", (Object)this.createdTime);
        builder.endObject();
        return builder;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getQuestion() {
        return this.question;
    }

    public void setQuestion(String question) {
        this.question = question;
    }

    public String getResponse() {
        return this.response;
    }

    public void setResponse(String response) {
        this.response = response;
    }

    public Boolean getFinalAnswer() {
        return this.finalAnswer;
    }

    public void setFinalAnswer(Boolean finalAnswer) {
        this.finalAnswer = finalAnswer;
    }

    public Instant getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(Instant createdTime) {
        this.createdTime = createdTime;
    }

    public static Builder conversationIndexMessageBuilder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConversationIndexMessage that = (ConversationIndexMessage)o;
        return Objects.equals(this.sessionId, that.sessionId) && Objects.equals(this.question, that.question) && Objects.equals(this.response, that.response) && Objects.equals(this.finalAnswer, that.finalAnswer) && Objects.equals(this.createdTime, that.createdTime);
    }

    public int hashCode() {
        return Objects.hash(this.sessionId, this.question, this.response, this.finalAnswer, this.createdTime);
    }

    public static class Builder {
        private String type;
        private String sessionId;
        private String question;
        private String response;
        private boolean finalAnswer;
        private Instant createdTime;

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public Builder question(String question) {
            this.question = question;
            return this;
        }

        public Builder response(String response) {
            this.response = response;
            return this;
        }

        public Builder finalAnswer(Boolean finalAnswer) {
            this.finalAnswer = finalAnswer;
            return this;
        }

        public Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public ConversationIndexMessage build() {
            return new ConversationIndexMessage(this.type, this.sessionId, this.question, this.response, this.finalAnswer);
        }
    }
}

