/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.exception;

import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.ml.common.exception.MLLimitExceededException;
import io.skylite.ml.common.exception.MLResourceNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Logger;

public class MLExceptionUtils {
    public static final String NOT_SERIALIZABLE_EXCEPTION_WRAPPER = "NotSerializableExceptionWrapper: ";
    public static final String REMOTE_INFERENCE_DISABLED_ERR_MSG = "Remote Inference is currently disabled. To enable it, update the setting \"plugins.ml_commons.remote_inference_enabled\" to true.";
    public static final String LOCAL_MODEL_DISABLED_ERR_MSG = "Local Model is currently disabled. To enable it, update the setting \"plugins.ml_commons.local_model.enabled\" to true.";
    public static final String BATCH_INFERENCE_DISABLED_ERR_MSG = "Offline Batch Inference is currently disabled. To enable it, update the setting \"plugins.ml_commons.offline_batch_inference_enabled\" to true.";
    public static final String AGENT_FRAMEWORK_DISABLED_ERR_MSG = "Agent Framework is currently disabled. To enable it, update the setting \"plugins.ml_commons.agent_framework_enabled\" to true.";
    public static final String CONTROLLER_DISABLED_ERR_MSG = "Controller is currently disabled. To enable it, update the setting \"plugins.ml_commons.controller_enabled\" to true.";
    public static final String OFFLINE_BATCH_INGESTION_DISABLED_ERR_MSG = "Offline batch ingestion is currently disabled. To enable it, update the setting \"plugins.ml_commons.offline_batch_ingestion_enabled\" to true.";

    public static String getRootCauseMessage(Throwable throwable) {
        String message = MLExceptionUtils.getShortRootCauseMessage(throwable);
        if (message != null && message.startsWith(NOT_SERIALIZABLE_EXCEPTION_WRAPPER)) {
            message = message.replace(NOT_SERIALIZABLE_EXCEPTION_WRAPPER, "");
        }
        message = message.substring(message.indexOf(":") + 2);
        return message;
    }

    public static String getShortRootCauseMessage(Throwable th) {
        Throwable root = MLExceptionUtils.getRootCause(th);
        root = root == null ? th : root;
        return MLExceptionUtils.getMessage(root);
    }

    public static String getMessage(Throwable th) {
        if (th == null) {
            return "";
        }
        String clsName = th == null ? null : (th.getClass() == null ? "" : th.getClass().getSimpleName());
        String msg = th.getMessage();
        String message = msg == null ? "" : msg;
        return clsName + ": " + message;
    }

    public static String toJsonString(Map<String, String> nodeErrors) throws IOException {
        if (nodeErrors == null || nodeErrors.size() == 0) {
            return null;
        }
        XContentBuilder builder = MediaTypeRegistry.JSON.contentBuilder();
        builder.startObject();
        for (Map.Entry<String, String> entry : nodeErrors.entrySet()) {
            builder.field(entry.getKey(), entry.getValue());
        }
        builder.endObject();
        return builder.toString();
    }

    public static void logException(String errorMessage, Exception e, Logger log) {
        Throwable rootCause = MLExceptionUtils.getRootCause(e);
        if (e instanceof MLLimitExceededException || e instanceof MLResourceNotFoundException || e instanceof IllegalArgumentException) {
            log.warn(e.getMessage());
        } else if (rootCause instanceof MLLimitExceededException || rootCause instanceof MLResourceNotFoundException || rootCause instanceof IllegalArgumentException) {
            log.warn(rootCause.getMessage());
        } else {
            log.error(errorMessage, (Throwable)e);
        }
    }

    public static Throwable getRootCause(Throwable throwable) {
        List<Throwable> list = MLExceptionUtils.getThrowableList(throwable);
        return list.isEmpty() ? null : list.get(list.size() - 1);
    }

    public static List<Throwable> getThrowableList(Throwable throwable) {
        ArrayList<Throwable> list = new ArrayList<Throwable>();
        while (throwable != null && !list.contains(throwable)) {
            list.add(throwable);
            throwable = throwable.getCause();
        }
        return list;
    }

    public static String getStackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        throwable.printStackTrace(pw);
        return sw.getBuffer().toString();
    }
}

