/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.input.execute.agent;

import io.skylite.Version;
import io.skylite.core.common.Strings;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.ml.common.CommonValue;
import io.skylite.ml.common.FunctionName;
import io.skylite.ml.common.dataset.MLInputDataset;
import io.skylite.ml.common.dataset.remote.RemoteInferenceInputDataSet;
import io.skylite.ml.common.input.MLInput;
import io.skylite.ml.common.input.parameter.MLAlgoParams;
import java.io.IOException;
import java.util.Map;

@io.skylite.ml.common.annotation.MLInput(functionNames={FunctionName.AGENT})
public class AgentMLInput
extends MLInput {
    public static final String AGENT_ID_FIELD = "agent_id";
    public static final String PARAMETERS_FIELD = "parameters";
    private String agentId;
    private String tenantId;

    public AgentMLInput(String agentId, String tenantId, FunctionName functionName, MLInputDataset inputDataset) {
        this.agentId = agentId;
        this.tenantId = tenantId;
        this.algorithm = functionName;
        this.inputDataset = inputDataset;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        Version streamOutputVersion = out.getVersion();
        out.writeString(this.agentId);
        if (streamOutputVersion.onOrAfter((Version)CommonValue.VERSION_2_19_0)) {
            out.writeOptionalString(this.tenantId);
        }
    }

    public AgentMLInput(StreamInput in) throws IOException {
        super(in);
        Version streamInputVersion = in.getVersion();
        this.agentId = in.readString();
        this.tenantId = streamInputVersion.onOrAfter((Version)CommonValue.VERSION_2_19_0) ? in.readOptionalString() : null;
    }

    public AgentMLInput(XContentParser parser, FunctionName functionName) throws IOException {
        this.algorithm = functionName;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block10: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "agent_id": {
                    this.agentId = parser.text();
                    continue block10;
                }
                case "tenant_id": {
                    this.tenantId = parser.textOrNull();
                    continue block10;
                }
                case "parameters": {
                    Map parameters = Strings.getJsonParameterMap((Map)parser.map());
                    this.inputDataset = new RemoteInferenceInputDataSet(parameters);
                    continue block10;
                }
            }
            parser.skipChildren();
        }
    }

    public String getAgentId() {
        return this.agentId;
    }

    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public static AgentMLInputBuilder AgentMLInputBuilder() {
        return new AgentMLInputBuilder();
    }

    public static class AgentMLInputBuilder
    extends MLInput.Builder {
        private String agentId;
        private String tenantId;

        public AgentMLInputBuilder agentId(String agentId) {
            this.agentId = agentId;
            return this;
        }

        public AgentMLInputBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @Override
        public AgentMLInputBuilder algorithm(FunctionName algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        @Override
        public AgentMLInputBuilder parameters(MLAlgoParams parameters) {
            this.parameters = parameters;
            return this;
        }

        @Override
        public AgentMLInputBuilder inputDataset(MLInputDataset inputDataset) {
            this.inputDataset = inputDataset;
            return this;
        }

        @Override
        public AgentMLInput build() {
            return new AgentMLInput(this.agentId, this.tenantId, this.algorithm, this.inputDataset);
        }
    }
}

