/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.input.execute.anomalylocalization;

import io.skylite.core.ParseField;
import io.skylite.core.aggregations.AggregationBuilder;
import io.skylite.core.aggregations.AggregatorFactories;
import io.skylite.core.common.io.stream.NamedWriteable;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.ml.common.FunctionName;
import io.skylite.ml.common.annotation.ExecuteInput;
import io.skylite.ml.common.input.Input;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@ExecuteInput(algorithms={FunctionName.ANOMALY_LOCALIZATION})
public class AnomalyLocalizationInput
implements Input {
    public static final String FIELD_INDEX_NAME = "index_name";
    public static final String FIELD_ATTTRIBUTE_FIELD_NAMES = "attribute_field_names";
    public static final String FIELD_AGGREGATIONS = "aggregations";
    public static final String FIELD_TIME_FIELD_NAME = "time_field_name";
    public static final String FIELD_START_TIME = "start_time";
    public static final String FIELD_END_TIME = "end_time";
    public static final String FIELD_MIN_TIME_INTERVAL = "min_time_interval";
    public static final String FIELD_NUM_OUTPUTS = "num_outputs";
    public static final String FIELD_ANOMALY_START_TIME = "anomaly_start_time";
    public static final String FIELD_FILTER_QUERY = "filter_query";
    public static final NamedXContentRegistry.Entry XCONTENT_REGISTRY_ENTRY = new NamedXContentRegistry.Entry(Input.class, new ParseField(FunctionName.ANOMALY_LOCALIZATION.name(), new String[0]), parser -> AnomalyLocalizationInput.parse(parser));
    private final String indexName;
    private final List<String> attributeFieldNames;
    private final List<AggregationBuilder> aggregations;
    private final String timeFieldName;
    private final long startTime;
    private final long endTime;
    private final long minTimeInterval;
    private final int numOutputs;
    private final Optional<Long> anomalyStartTime;
    private final Optional<QueryBuilder> filterQuery;

    public static AnomalyLocalizationInput parse(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        String indexName = null;
        ArrayList<String> attributeFieldNames = new ArrayList<String>();
        ArrayList<AggregationBuilder> aggregations = new ArrayList<AggregationBuilder>();
        String timeFieldName = null;
        long startTime = 0L;
        long endTime = 0L;
        long minTimeInterval = 0L;
        int numOutputs = 0;
        Optional<Long> anomalyStartTime = Optional.empty();
        Optional<QueryBuilder> filterQuery = Optional.empty();
        block24: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            switch (parser.currentName()) {
                case "index_name": {
                    parser.nextToken();
                    indexName = parser.text();
                    continue block24;
                }
                case "attribute_field_names": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        attributeFieldNames.add(parser.text());
                    }
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.END_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    continue block24;
                }
                case "aggregations": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                        aggregations.addAll(AggregatorFactories.parseAggregators((XContentParser)parser).getAggregatorFactories());
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.END_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    }
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.END_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    continue block24;
                }
                case "time_field_name": {
                    parser.nextToken();
                    timeFieldName = parser.text();
                    continue block24;
                }
                case "start_time": {
                    parser.nextToken();
                    startTime = parser.longValue(false);
                    continue block24;
                }
                case "end_time": {
                    parser.nextToken();
                    endTime = parser.longValue(false);
                    continue block24;
                }
                case "min_time_interval": {
                    parser.nextToken();
                    minTimeInterval = parser.longValue(false);
                    continue block24;
                }
                case "num_outputs": {
                    parser.nextToken();
                    numOutputs = parser.intValue(false);
                    continue block24;
                }
                case "anomaly_start_time": {
                    parser.nextToken();
                    anomalyStartTime = Optional.of(parser.longValue(false));
                    continue block24;
                }
                case "filter_query": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                    filterQuery = Optional.of(QueryBuilder.parseInnerQueryBuilder((XContentParser)parser));
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.END_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    continue block24;
                }
            }
            parser.skipChildren();
        }
        return new AnomalyLocalizationInput(indexName, attributeFieldNames, aggregations, timeFieldName, startTime, endTime, minTimeInterval, numOutputs, anomalyStartTime, filterQuery);
    }

    public AnomalyLocalizationInput(String indexName, List<String> attributeFieldNames, List<AggregationBuilder> aggregations, String timeFieldName, long startTime, long endTime, long minTimeInterval, int numOutputs, Optional<Long> anomalyStartTime, Optional<QueryBuilder> filterQuery) {
        this.indexName = indexName;
        this.attributeFieldNames = attributeFieldNames;
        this.aggregations = aggregations;
        this.timeFieldName = timeFieldName;
        this.startTime = startTime;
        this.endTime = endTime;
        this.minTimeInterval = minTimeInterval;
        this.numOutputs = numOutputs;
        this.anomalyStartTime = anomalyStartTime;
        this.filterQuery = filterQuery;
    }

    public AnomalyLocalizationInput(StreamInput in) throws IOException {
        this.indexName = in.readString();
        this.attributeFieldNames = Arrays.asList(in.readStringArray());
        this.aggregations = in.readNamedWriteableList(AggregationBuilder.class);
        this.timeFieldName = in.readString();
        this.startTime = in.readLong();
        this.endTime = in.readLong();
        this.minTimeInterval = in.readLong();
        this.numOutputs = in.readInt();
        this.anomalyStartTime = Optional.ofNullable(in.readOptionalLong());
        this.filterQuery = Optional.ofNullable((QueryBuilder)in.readOptionalNamedWriteable(QueryBuilder.class));
    }

    @Override
    public FunctionName getFunctionName() {
        return FunctionName.ANOMALY_LOCALIZATION;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(FIELD_INDEX_NAME, this.indexName);
        builder.field(FIELD_ATTTRIBUTE_FIELD_NAMES, this.attributeFieldNames);
        builder.startArray(FIELD_AGGREGATIONS);
        for (AggregationBuilder agg : this.aggregations) {
            builder.startObject();
            builder.value((Object)agg);
            builder.endObject();
        }
        builder.endArray();
        builder.field(FIELD_TIME_FIELD_NAME, this.timeFieldName);
        builder.field(FIELD_START_TIME, this.startTime);
        builder.field(FIELD_END_TIME, this.endTime);
        builder.field(FIELD_MIN_TIME_INTERVAL, this.minTimeInterval);
        builder.field(FIELD_NUM_OUTPUTS, this.numOutputs);
        if (this.anomalyStartTime.isPresent()) {
            builder.field(FIELD_ANOMALY_START_TIME, this.anomalyStartTime.get());
        }
        if (this.filterQuery.isPresent()) {
            builder.field(FIELD_FILTER_QUERY, (ToXContent)this.filterQuery.get());
        }
        builder.endObject();
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.indexName);
        out.writeStringArray(this.attributeFieldNames.toArray(new String[0]));
        out.writeNamedWriteableList(this.aggregations);
        out.writeString(this.timeFieldName);
        out.writeLong(this.startTime);
        out.writeLong(this.endTime);
        out.writeLong(this.minTimeInterval);
        out.writeInt(this.numOutputs);
        out.writeOptionalLong((Long)this.anomalyStartTime.orElse(null));
        out.writeOptionalNamedWriteable((NamedWriteable)this.filterQuery.orElse(null));
    }

    public String getIndexName() {
        return this.indexName;
    }

    public List<String> getAttributeFieldNames() {
        return this.attributeFieldNames;
    }

    public List<AggregationBuilder> getAggregations() {
        return this.aggregations;
    }

    public String getTimeFieldName() {
        return this.timeFieldName;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public long getMinTimeInterval() {
        return this.minTimeInterval;
    }

    public int getNumOutputs() {
        return this.numOutputs;
    }

    public Optional<Long> getAnomalyStartTime() {
        return this.anomalyStartTime;
    }

    public Optional<QueryBuilder> getFilterQuery() {
        return this.filterQuery;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnomalyLocalizationInput that = (AnomalyLocalizationInput)o;
        return this.startTime == that.startTime && this.endTime == that.endTime && this.minTimeInterval == that.minTimeInterval && this.numOutputs == that.numOutputs && Objects.equals(this.indexName, that.indexName) && Objects.equals(this.attributeFieldNames, that.attributeFieldNames) && Objects.equals(this.aggregations, that.aggregations) && Objects.equals(this.timeFieldName, that.timeFieldName) && Objects.equals(this.anomalyStartTime, that.anomalyStartTime) && Objects.equals(this.filterQuery, that.filterQuery);
    }

    public int hashCode() {
        return Objects.hash(this.indexName, this.attributeFieldNames, this.aggregations, this.timeFieldName, this.startTime, this.endTime, this.minTimeInterval, this.numOutputs, this.anomalyStartTime, this.filterQuery);
    }

    public String toString() {
        return "AnomalyLocalizationInput{indexName='" + this.indexName + "', attributeFieldNames=" + String.valueOf(this.attributeFieldNames) + ", aggregations=" + String.valueOf(this.aggregations) + ", timeFieldName='" + this.timeFieldName + "', startTime=" + this.startTime + ", endTime=" + this.endTime + ", minTimeInterval=" + this.minTimeInterval + ", numOutputs=" + this.numOutputs + ", anomalyStartTime=" + String.valueOf(this.anomalyStartTime) + ", filterQuery=" + String.valueOf(this.filterQuery) + "}";
    }
}

