/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.input.parameter.textembedding;

import io.skylite.core.ParseField;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.ml.common.FunctionName;
import io.skylite.ml.common.annotation.MLAlgoParameter;
import io.skylite.ml.common.input.parameter.MLAlgoParams;
import java.io.IOException;
import java.util.Locale;
import java.util.Objects;

@MLAlgoParameter(algorithms={FunctionName.TEXT_EMBEDDING})
public class AsymmetricTextEmbeddingParameters
implements MLAlgoParams {
    private EmbeddingContentType embeddingContentType;
    public static final String PARSE_FIELD_NAME = FunctionName.TEXT_EMBEDDING.name();
    public static final NamedXContentRegistry.Entry XCONTENT_REGISTRY = new NamedXContentRegistry.Entry(MLAlgoParams.class, new ParseField(PARSE_FIELD_NAME, new String[0]), it -> AsymmetricTextEmbeddingParameters.parse(it));
    public static final String EMBEDDING_CONTENT_TYPE_FIELD = "content_type";

    public AsymmetricTextEmbeddingParameters(EmbeddingContentType embeddingContentType) {
        this.embeddingContentType = embeddingContentType;
    }

    public AsymmetricTextEmbeddingParameters(StreamInput in) throws IOException {
        this.embeddingContentType = EmbeddingContentType.valueOf(in.readOptionalString());
    }

    public static MLAlgoParams parse(XContentParser parser) throws IOException {
        EmbeddingContentType embeddingContentType = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block6: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "content_type": {
                    String contentType = parser.text();
                    embeddingContentType = EmbeddingContentType.valueOf(contentType.toUpperCase(Locale.ROOT));
                    continue block6;
                }
            }
            parser.skipChildren();
        }
        return new AsymmetricTextEmbeddingParameters(embeddingContentType);
    }

    public EmbeddingContentType getEmbeddingContentType() {
        return this.embeddingContentType;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public int getVersion() {
        return 1;
    }

    public String getWriteableName() {
        return PARSE_FIELD_NAME;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.embeddingContentType.name());
    }

    public XContentBuilder toXContent(XContentBuilder xContentBuilder, ToXContent.Params params) throws IOException {
        xContentBuilder.startObject();
        if (this.embeddingContentType != null) {
            xContentBuilder.field(EMBEDDING_CONTENT_TYPE_FIELD, this.embeddingContentType.name());
        }
        xContentBuilder.endObject();
        return xContentBuilder;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AsymmetricTextEmbeddingParameters that = (AsymmetricTextEmbeddingParameters)o;
        return this.embeddingContentType == that.embeddingContentType;
    }

    public int hashCode() {
        return Objects.hashCode((Object)this.embeddingContentType);
    }

    public static enum EmbeddingContentType {
        QUERY,
        PASSAGE;

    }

    public static class Builder {
        private EmbeddingContentType embeddingContentType;

        public Builder embeddingContentType(EmbeddingContentType embeddingContentType) {
            this.embeddingContentType = embeddingContentType;
            return this;
        }

        public AsymmetricTextEmbeddingParameters build() {
            return new AsymmetricTextEmbeddingParameters(this.embeddingContentType);
        }
    }
}

