/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.model;

import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.ml.common.model.Guardrail;
import io.skylite.ml.common.model.GuardrailFactory;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;

public class Guardrails
implements ToXContentObject {
    public static final String TYPE_FIELD = "type";
    public static final String INPUT_GUARDRAIL_FIELD = "input_guardrail";
    public static final String OUTPUT_GUARDRAIL_FIELD = "output_guardrail";
    private static Map<String, GuardrailFactory> REGISTRY;
    private static final Set<String> TYPES;
    private String type;
    private Guardrail inputGuardrail;
    private Guardrail outputGuardrail;

    public Guardrails(String type, Guardrail inputGuardrail, Guardrail outputGuardrail) {
        this.type = type;
        this.inputGuardrail = inputGuardrail;
        this.outputGuardrail = outputGuardrail;
    }

    public Guardrails(StreamInput input) throws IOException {
        this.type = input.readString();
        if (!REGISTRY.containsKey(this.type)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Unsupported guardrails type: %s", this.type));
        }
        GuardrailFactory factory = REGISTRY.get(this.type);
        if (input.readBoolean()) {
            this.inputGuardrail = factory.newInstance(input);
        }
        if (input.readBoolean()) {
            this.outputGuardrail = factory.newInstance(input);
        }
    }

    public String getType() {
        return this.type;
    }

    public Guardrail getInputGuardrail() {
        return this.inputGuardrail;
    }

    public Guardrail getOutputGuardrail() {
        return this.outputGuardrail;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.type);
        if (this.inputGuardrail != null) {
            out.writeBoolean(true);
            this.inputGuardrail.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        if (this.outputGuardrail != null) {
            out.writeBoolean(true);
            this.outputGuardrail.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.type != null) {
            builder.field(TYPE_FIELD, this.type);
        }
        if (this.inputGuardrail != null) {
            builder.field(INPUT_GUARDRAIL_FIELD, (ToXContent)this.inputGuardrail);
        }
        if (this.outputGuardrail != null) {
            builder.field(OUTPUT_GUARDRAIL_FIELD, (ToXContent)this.outputGuardrail);
        }
        builder.endObject();
        return builder;
    }

    public static Guardrails parse(XContentParser parser) throws IOException {
        String type = null;
        Map inputGuardrailMap = null;
        Map outputGuardrailMap = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block10: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "type": {
                    type = parser.text();
                    continue block10;
                }
                case "input_guardrail": {
                    inputGuardrailMap = parser.map();
                    continue block10;
                }
                case "output_guardrail": {
                    outputGuardrailMap = parser.map();
                    continue block10;
                }
            }
            parser.skipChildren();
        }
        if (type == null) {
            type = "local_regex";
        }
        if (!Guardrails.validateType(type).booleanValue()) {
            throw new IllegalArgumentException("The type of guardrails is required, can not be null.");
        }
        return Guardrails.builder().type(type).inputGuardrail(Guardrails.createGuardrail(type, inputGuardrailMap)).outputGuardrail(Guardrails.createGuardrail(type, outputGuardrailMap)).build();
    }

    private static Boolean validateType(String type) {
        if (TYPES.contains(type)) {
            return true;
        }
        return false;
    }

    private static Guardrail createGuardrail(String type, Map<String, Object> params) {
        if (params == null || params.isEmpty()) {
            return null;
        }
        return Optional.ofNullable(REGISTRY.get(type)).orElseThrow(() -> new IllegalArgumentException(String.format(Locale.ROOT, "Unsupported guardrail type: %s", type))).newInstance(params);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Guardrails that = (Guardrails)o;
        return this.type.equals(that.type) && Objects.equals(this.inputGuardrail, that.inputGuardrail) && Objects.equals(this.outputGuardrail, that.outputGuardrail);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + (this.inputGuardrail != null ? this.inputGuardrail.hashCode() : 0);
        result = 31 * result + (this.outputGuardrail != null ? this.outputGuardrail.hashCode() : 0);
        return result;
    }

    static {
        HashMap<String, GuardrailFactory> guardrails = new HashMap<String, GuardrailFactory>();
        for (GuardrailFactory guardrailFactory : ServiceLoader.load(GuardrailFactory.class, Guardrail.class.getClassLoader())) {
            guardrails.put(guardrailFactory.typeName(), guardrailFactory);
        }
        REGISTRY = Map.copyOf(guardrails);
        TYPES = Set.copyOf(REGISTRY.keySet());
    }

    public static class Builder {
        private String type;
        private Guardrail inputGuardrail;
        private Guardrail outputGuardrail;

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder outputGuardrail(Guardrail outputGuardrail) {
            this.outputGuardrail = outputGuardrail;
            return this;
        }

        public Builder inputGuardrail(Guardrail inputGuardrail) {
            this.inputGuardrail = inputGuardrail;
            return this;
        }

        public Guardrails build() {
            return new Guardrails(this.type, this.inputGuardrail, this.outputGuardrail);
        }
    }
}

