/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.model;

import io.skylite.core.client.ReleasableSkyliteClient;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.ml.common.model.Guardrails;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MLGuard {
    private static final Logger log = LogManager.getLogger(MLGuard.class);
    private NamedXContentRegistry xContentRegistry;
    private ReleasableSkyliteClient client;
    private Guardrails guardrails;

    public MLGuard(Guardrails guardrails, NamedXContentRegistry xContentRegistry, ReleasableSkyliteClient client) {
        this.xContentRegistry = xContentRegistry;
        this.client = client;
        this.guardrails = guardrails;
        if (this.guardrails != null && this.guardrails.getInputGuardrail() != null) {
            this.guardrails.getInputGuardrail().init(xContentRegistry, client);
        }
        if (this.guardrails != null && this.guardrails.getOutputGuardrail() != null) {
            this.guardrails.getOutputGuardrail().init(xContentRegistry, client);
        }
    }

    public Boolean validate(String input, Type type, Map<String, String> parameters) {
        switch (type.ordinal()) {
            case 0: {
                return this.guardrails.getInputGuardrail() == null ? true : this.guardrails.getInputGuardrail().validate(input, parameters);
            }
            case 1: {
                return this.guardrails.getOutputGuardrail() == null ? true : this.guardrails.getOutputGuardrail().validate(input, parameters);
            }
        }
        throw new IllegalArgumentException("Unsupported type [" + String.valueOf((Object)type) + "] to validate for guardrails.");
    }

    public NamedXContentRegistry getxContentRegistry() {
        return this.xContentRegistry;
    }

    public Guardrails getGuardrails() {
        return this.guardrails;
    }

    public ReleasableSkyliteClient getClient() {
        return this.client;
    }

    public static enum Type {
        INPUT,
        OUTPUT;

    }
}

