/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.output;

import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.ml.common.annotation.MLAlgoOutput;
import io.skylite.ml.common.dataframe.DataFrame;
import io.skylite.ml.common.dataframe.DataFrameType;
import io.skylite.ml.common.dataframe.DefaultDataFrame;
import io.skylite.ml.common.output.MLOutput;
import io.skylite.ml.common.output.MLOutputType;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;

@MLAlgoOutput(value=MLOutputType.PREDICTION)
public class MLPredictionOutput
extends MLOutput {
    private static final MLOutputType OUTPUT_TYPE = MLOutputType.PREDICTION;
    public static final String TASK_ID_FIELD = "task_id";
    public static final String STATUS_FIELD = "status";
    public static final String PREDICTION_RESULT_FIELD = "prediction_result";
    public static final String REMOTE_JOB_FIELD = "remote_job";
    private String taskId;
    private String status;
    private Map<String, Object> remoteJob;
    private DataFrame predictionResult;

    public MLPredictionOutput(String taskId, String status, DataFrame predictionResult) {
        super(OUTPUT_TYPE);
        this.taskId = taskId;
        this.status = status;
        this.predictionResult = predictionResult;
    }

    public MLPredictionOutput(String taskId, String status, Map<String, Object> remoteJob) {
        super(OUTPUT_TYPE);
        this.taskId = taskId;
        this.status = status;
        this.remoteJob = remoteJob;
    }

    public MLPredictionOutput(StreamInput in) throws IOException {
        super(OUTPUT_TYPE);
        this.taskId = in.readOptionalString();
        this.status = in.readOptionalString();
        if (in.readBoolean()) {
            DataFrameType dataFrameType = (DataFrameType)in.readEnum(DataFrameType.class);
            switch (dataFrameType) {
                default: 
            }
            this.predictionResult = new DefaultDataFrame(in);
        }
        if (in.readBoolean()) {
            this.remoteJob = in.readMap(s -> s.readString(), s -> s.readGenericValue());
        }
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public DataFrame getPredictionResult() {
        return this.predictionResult;
    }

    public void setPredictionResult(DataFrame predictionResult) {
        this.predictionResult = predictionResult;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalString(this.taskId);
        out.writeOptionalString(this.status);
        if (this.predictionResult != null) {
            out.writeBoolean(true);
            this.predictionResult.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        if (this.remoteJob != null) {
            out.writeBoolean(true);
            out.writeMap(this.remoteJob, StreamOutput::writeString, StreamOutput::writeGenericValue);
        } else {
            out.writeBoolean(false);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.taskId != null) {
            builder.field(TASK_ID_FIELD, this.taskId);
        }
        if (this.status != null) {
            builder.field(STATUS_FIELD, this.status);
        }
        if (this.predictionResult != null) {
            builder.startObject(PREDICTION_RESULT_FIELD);
            this.predictionResult.toXContent(builder, params);
            builder.endObject();
        }
        if (this.remoteJob != null) {
            builder.field(REMOTE_JOB_FIELD, this.remoteJob);
        }
        builder.endObject();
        return builder;
    }

    @Override
    public MLOutputType getType() {
        return OUTPUT_TYPE;
    }

    public String toString() {
        return "MLPredictionOutput{taskId='" + this.taskId + "', status='" + this.status + "', remoteJob=" + String.valueOf(this.remoteJob) + ", outputType=" + String.valueOf((Object)this.outputType) + "}";
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MLPredictionOutput that = (MLPredictionOutput)o;
        return Objects.equals(this.taskId, that.taskId) && Objects.equals(this.status, that.status) && Objects.equals(this.remoteJob, that.remoteJob) && Objects.equals(this.predictionResult, that.predictionResult);
    }

    public int hashCode() {
        return Objects.hash(this.taskId, this.status, this.remoteJob, this.predictionResult);
    }

    public static class Builder {
        private String taskId;
        private String status;
        private DataFrame predictionResult;

        public MLPredictionOutput build() {
            return new MLPredictionOutput(this.taskId, this.status, this.predictionResult);
        }

        public Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            return this;
        }

        public Builder predictionResult(DataFrame predictionResult) {
            this.predictionResult = predictionResult;
            return this;
        }
    }
}

