/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.output;

import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.ml.common.annotation.MLAlgoOutput;
import io.skylite.ml.common.output.MLOutput;
import io.skylite.ml.common.output.MLOutputType;
import java.io.IOException;

@MLAlgoOutput(value=MLOutputType.TRAINING)
public class MLTrainingOutput
extends MLOutput {
    private static final MLOutputType OUTPUT_TYPE = MLOutputType.TRAINING;
    public static final String MODEL_ID_FIELD = "model_id";
    public static final String TASK_ID_FIELD = "task_id";
    public static final String STATUS_FIELD = "status";
    private String modelId;
    private String taskId;
    private String status;

    public MLTrainingOutput(String modelId, String taskId, String status) {
        super(OUTPUT_TYPE);
        this.modelId = modelId;
        this.taskId = taskId;
        this.status = status;
    }

    public MLTrainingOutput(StreamInput in) throws IOException {
        super(OUTPUT_TYPE);
        this.modelId = in.readOptionalString();
        this.taskId = in.readOptionalString();
        this.status = in.readOptionalString();
    }

    public String getModelId() {
        return this.modelId;
    }

    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @Override
    public MLOutputType getType() {
        return OUTPUT_TYPE;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalString(this.modelId);
        out.writeOptionalString(this.taskId);
        out.writeOptionalString(this.status);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.modelId != null) {
            builder.field(MODEL_ID_FIELD, this.modelId);
        }
        if (this.taskId != null) {
            builder.field(TASK_ID_FIELD, this.taskId);
        }
        builder.field(STATUS_FIELD, this.status);
        builder.endObject();
        return builder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String modelId;
        private String taskId;
        private String status;

        public MLTrainingOutput build() {
            return new MLTrainingOutput(this.modelId, this.taskId, this.status);
        }

        public Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            return this;
        }
    }
}

