/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.output.model;

import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ModelResultFilter
implements Writeable {
    public static final String RETURN_BYTES_FIELD = "return_bytes";
    public static final String RETURN_NUMBER_FIELD = "return_number";
    public static final String TARGET_RESPONSE_FIELD = "target_response";
    public static final String TARGET_RESPONSE_POSITIONS_FIELD = "target_response_positions";
    protected final boolean returnBytes;
    protected final boolean returnNumber;
    protected final List<String> targetResponse;
    protected final List<Integer> targetResponsePositions;

    public ModelResultFilter(boolean returnBytes, boolean returnNumber, List<String> targetResponse, List<Integer> targetResponsePositions) {
        this.returnBytes = returnBytes;
        this.returnNumber = returnNumber;
        this.targetResponse = targetResponse;
        this.targetResponsePositions = targetResponsePositions;
    }

    public ModelResultFilter(StreamInput streamInput) throws IOException {
        this.returnBytes = streamInput.readBoolean();
        this.returnNumber = streamInput.readBoolean();
        this.targetResponse = streamInput.readOptionalStringList();
        if (streamInput.readBoolean()) {
            int size = streamInput.readInt();
            this.targetResponsePositions = new ArrayList<Integer>();
            for (int i = 0; i < size; ++i) {
                this.targetResponsePositions.add(streamInput.readInt());
            }
        } else {
            this.targetResponsePositions = null;
        }
    }

    public boolean isReturnBytes() {
        return this.returnBytes;
    }

    public List<Integer> getTargetResponsePositions() {
        return this.targetResponsePositions;
    }

    public List<String> getTargetResponse() {
        return this.targetResponse;
    }

    public boolean isReturnNumber() {
        return this.returnNumber;
    }

    public void writeTo(StreamOutput streamOutput) throws IOException {
        streamOutput.writeBoolean(this.returnBytes);
        streamOutput.writeBoolean(this.returnNumber);
        streamOutput.writeOptionalStringCollection(this.targetResponse);
        if (this.targetResponsePositions != null && this.targetResponsePositions.size() > 0) {
            streamOutput.writeBoolean(true);
            streamOutput.writeInt(this.targetResponsePositions.size());
            for (Integer value : this.targetResponsePositions) {
                streamOutput.writeInt(value.intValue());
            }
        } else {
            streamOutput.writeBoolean(false);
        }
    }

    public static ModelResultFilter parse(XContentParser parser) throws IOException {
        boolean returnBytes = false;
        boolean returnNumber = true;
        ArrayList<String> targetResponse = new ArrayList<String>();
        ArrayList<Integer> targetResponsePositions = new ArrayList<Integer>();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block12: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "return_bytes": {
                    returnBytes = parser.booleanValue();
                    continue block12;
                }
                case "return_number": {
                    returnNumber = parser.booleanValue();
                    continue block12;
                }
                case "target_response": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        targetResponse.add(parser.text());
                    }
                    continue block12;
                }
                case "target_response_positions": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        targetResponsePositions.add(parser.intValue());
                    }
                    continue block12;
                }
            }
            parser.skipChildren();
        }
        return new ModelResultFilter(returnBytes, returnNumber, targetResponse, targetResponsePositions);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        protected boolean returnBytes;
        protected boolean returnNumber;
        protected List<String> targetResponse;
        protected List<Integer> targetResponsePositions;

        public Builder returnBytes(boolean returnBytes) {
            this.returnBytes = returnBytes;
            return this;
        }

        public Builder returnNumber(boolean returnNumber) {
            this.returnNumber = returnNumber;
            return this;
        }

        public Builder targetResponse(List<String> targetResponse) {
            this.targetResponse = targetResponse;
            return this;
        }

        public Builder targetResponsePositions(List<Integer> targetResponsePositions) {
            this.targetResponsePositions = targetResponsePositions;
            return this;
        }

        public ModelResultFilter build() {
            return new ModelResultFilter(this.returnBytes, this.returnNumber, this.targetResponse, this.targetResponsePositions);
        }
    }
}

