/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.output.model;

import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.ml.common.annotation.MLAlgoOutput;
import io.skylite.ml.common.output.MLOutput;
import io.skylite.ml.common.output.MLOutputType;
import io.skylite.ml.common.output.model.ModelTensors;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@MLAlgoOutput(value=MLOutputType.MODEL_TENSOR)
public class ModelTensorOutput
extends MLOutput {
    private static final MLOutputType OUTPUT_TYPE = MLOutputType.MODEL_TENSOR;
    public static final String INFERENCE_RESULT_FIELD = "inference_results";
    private List<ModelTensors> mlModelOutputs;

    public ModelTensorOutput(List<ModelTensors> mlModelOutputs) {
        super(OUTPUT_TYPE);
        this.mlModelOutputs = mlModelOutputs;
    }

    public ModelTensorOutput(StreamInput in) throws IOException {
        super(OUTPUT_TYPE);
        if (in.readBoolean()) {
            this.mlModelOutputs = new ArrayList<ModelTensors>();
            int size = in.readInt();
            for (int i = 0; i < size; ++i) {
                this.mlModelOutputs.add(new ModelTensors(in));
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (this.mlModelOutputs != null && this.mlModelOutputs.size() > 0) {
            out.writeBoolean(true);
            out.writeInt(this.mlModelOutputs.size());
            for (ModelTensors output : this.mlModelOutputs) {
                output.writeTo(out);
            }
        } else {
            out.writeBoolean(false);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.mlModelOutputs != null && this.mlModelOutputs.size() > 0) {
            builder.startArray(INFERENCE_RESULT_FIELD);
            for (ModelTensors output : this.mlModelOutputs) {
                output.toXContent(builder, params);
            }
            builder.endArray();
        }
        builder.endObject();
        return builder;
    }

    @Override
    protected MLOutputType getType() {
        return OUTPUT_TYPE;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModelTensorOutput that = (ModelTensorOutput)o;
        return Objects.equals(this.mlModelOutputs, that.mlModelOutputs);
    }

    public int hashCode() {
        return Objects.hashCode(this.mlModelOutputs);
    }

    public List<ModelTensors> getMlModelOutputs() {
        return this.mlModelOutputs;
    }

    public ModelTensorOutput mlModelOutputs(List<ModelTensors> mlModelOutputs) {
        this.mlModelOutputs = mlModelOutputs;
        return this;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private List<ModelTensors> mlModelOutputs;

        public Builder mlModelOutputs(List<ModelTensors> mlModelOutputs) {
            this.mlModelOutputs = mlModelOutputs;
            return this;
        }

        public ModelTensorOutput build() {
            return new ModelTensorOutput(this.mlModelOutputs);
        }
    }
}

