/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.output.sample;

import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.ml.common.annotation.MLAlgoOutput;
import io.skylite.ml.common.output.MLOutput;
import io.skylite.ml.common.output.MLOutputType;
import java.io.IOException;
import java.util.Objects;

@MLAlgoOutput(value=MLOutputType.SAMPLE_ALGO)
public class SampleAlgoOutput
extends MLOutput {
    private static final MLOutputType OUTPUT_TYPE = MLOutputType.SAMPLE_ALGO;
    public static final String SAMPLE_RESULT_FIELD = "sample_result";
    private Double sampleResult;

    public SampleAlgoOutput(Double sampleResult) {
        super(OUTPUT_TYPE);
        this.sampleResult = sampleResult;
    }

    public SampleAlgoOutput(StreamInput in) throws IOException {
        super(OUTPUT_TYPE);
        this.sampleResult = in.readOptionalDouble();
    }

    public Double getSampleResult() {
        return this.sampleResult;
    }

    public void setSampleResult(Double sampleResult) {
        this.sampleResult = sampleResult;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalDouble(this.sampleResult);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.sampleResult != null) {
            builder.field(SAMPLE_RESULT_FIELD, this.sampleResult);
        }
        builder.endObject();
        return builder;
    }

    @Override
    public MLOutputType getType() {
        return OUTPUT_TYPE;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SampleAlgoOutput that = (SampleAlgoOutput)o;
        return Objects.equals(this.sampleResult, that.sampleResult);
    }

    public int hashCode() {
        return Objects.hashCode(this.sampleResult);
    }

    public String toString() {
        return "SampleAlgoOutput{sampleResult=" + this.sampleResult + "}";
    }

    public static class Builder {
        private Double sampleResult;

        public SampleAlgoOutput build() {
            return new SampleAlgoOutput(this.sampleResult);
        }

        public Builder sampleResult(Double sampleResult) {
            this.sampleResult = sampleResult;
            return this;
        }
    }
}

