/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.profile;

import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.ml.common.cluster.MLNodeUtils;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class MLProfileInput
implements ToXContentObject,
Writeable {
    public static final String MODELS = "model_ids";
    public static final String TASKS = "task_ids";
    public static final String NODE_IDS = "node_ids";
    public static final String RETURN_ALL_TASKS = "return_all_tasks";
    public static final String RETURN_ALL_MODELS = "return_all_models";
    private Set<String> modelIds;
    private Set<String> taskIds;
    private Set<String> nodeIds;
    private boolean returnAllTasks;
    private boolean returnAllModels;

    public MLProfileInput(Set<String> modelIds, Set<String> taskIds, Set<String> nodeIds, boolean returnAllTasks, boolean returnAllModels) {
        this.modelIds = modelIds;
        this.taskIds = taskIds;
        this.nodeIds = nodeIds;
        this.returnAllTasks = returnAllTasks;
        this.returnAllModels = returnAllModels;
    }

    public MLProfileInput() {
        this.modelIds = new HashSet<String>();
        this.taskIds = new HashSet<String>();
        this.nodeIds = new HashSet<String>();
        this.returnAllTasks = false;
        this.returnAllModels = false;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalStringCollection(this.modelIds);
        out.writeOptionalStringCollection(this.taskIds);
        out.writeOptionalStringCollection(this.nodeIds);
        out.writeBoolean(this.returnAllTasks);
        out.writeBoolean(this.returnAllModels);
    }

    public MLProfileInput(StreamInput input) throws IOException {
        this.modelIds = input.readBoolean() ? new HashSet(input.readStringList()) : new HashSet();
        this.taskIds = input.readBoolean() ? new HashSet(input.readStringList()) : new HashSet();
        this.nodeIds = input.readBoolean() ? new HashSet(input.readStringList()) : new HashSet();
        this.returnAllTasks = input.readBoolean();
        this.returnAllModels = input.readBoolean();
    }

    public static MLProfileInput parse(XContentParser parser) throws IOException {
        HashSet<String> modelIds = new HashSet<String>();
        HashSet<String> taskIds = new HashSet<String>();
        HashSet<String> nodeIds = new HashSet<String>();
        boolean returnALlTasks = false;
        boolean returnAllModels = false;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block14: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "model_ids": {
                    MLNodeUtils.parseArrayField(parser, modelIds);
                    continue block14;
                }
                case "task_ids": {
                    MLNodeUtils.parseArrayField(parser, taskIds);
                    continue block14;
                }
                case "node_ids": {
                    MLNodeUtils.parseArrayField(parser, nodeIds);
                    continue block14;
                }
                case "return_all_tasks": {
                    returnALlTasks = parser.booleanValue();
                    continue block14;
                }
                case "return_all_models": {
                    returnAllModels = parser.booleanValue();
                    continue block14;
                }
            }
            parser.skipChildren();
        }
        return MLProfileInput.builder().modelIds(modelIds).taskIds(taskIds).nodeIds(nodeIds).returnAllTasks(returnALlTasks).returnAllModels(returnAllModels).build();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.modelIds != null) {
            builder.field(MODELS, this.modelIds);
        }
        if (this.taskIds != null) {
            builder.field(TASKS, this.taskIds);
        }
        if (this.nodeIds != null) {
            builder.field(NODE_IDS, this.nodeIds);
        }
        builder.field(RETURN_ALL_TASKS, this.returnAllTasks);
        builder.field(RETURN_ALL_MODELS, this.returnAllModels);
        builder.endObject();
        return builder;
    }

    public boolean retrieveProfileOnAllNodes() {
        return this.nodeIds == null || this.nodeIds.size() == 0;
    }

    public boolean emptyTasks() {
        return this.taskIds == null || this.taskIds.size() == 0;
    }

    public boolean emptyModels() {
        return this.modelIds == null || this.modelIds.size() == 0;
    }

    public void setReturnAllTasks(boolean returnAllTasks) {
        this.returnAllTasks = returnAllTasks;
    }

    public void setReturnAllModels(boolean returnAllModels) {
        this.returnAllModels = returnAllModels;
    }

    public Set<String> getModelIds() {
        return this.modelIds;
    }

    public Set<String> getTaskIds() {
        return this.taskIds;
    }

    public Set<String> getNodeIds() {
        return this.nodeIds;
    }

    public boolean isReturnAllTasks() {
        return this.returnAllTasks;
    }

    public boolean isReturnAllModels() {
        return this.returnAllModels;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Set<String> modelIds;
        private Set<String> taskIds;
        private Set<String> nodeIds;
        private boolean returnAllTasks;
        private boolean returnAllModels;

        public Builder modelIds(Set<String> modelIds) {
            this.modelIds = modelIds;
            return this;
        }

        public Builder taskIds(Set<String> taskIds) {
            this.taskIds = taskIds;
            return this;
        }

        public Builder nodeIds(Set<String> nodeIds) {
            this.nodeIds = nodeIds;
            return this;
        }

        public Builder returnAllTasks(boolean returnAllTasks) {
            this.returnAllTasks = returnAllTasks;
            return this;
        }

        public Builder returnAllModels(boolean returnAllModels) {
            this.returnAllModels = returnAllModels;
            return this;
        }

        public MLProfileInput build() {
            return new MLProfileInput(this.modelIds, this.taskIds, this.nodeIds, this.returnAllTasks, this.returnAllModels);
        }
    }
}

