/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.search.pipelines.generative.prompt;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.skylite.core.common.Strings;
import io.skylite.ml.common.conversation.Interaction;
import io.skylite.ml.common.search.pipelines.generative.llm.Llm;
import io.skylite.ml.common.search.pipelines.generative.llm.MessageBlock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import org.apache.commons.text.StringEscapeUtils;

public class PromptUtil {
    public static final String DEFAULT_SYSTEM_PROMPT = "Generate a concise and informative answer in less than 100 words for the given question, taking into context: - An enumerated list of search results- A rephrase of the question that was used to generate the search results- The conversation historyCite search results using [${number}] notation.Do not repeat yourself, and NEVER repeat anything in the chat history.If there are any necessary steps or procedures in your answer, enumerate them.";
    private static final String roleUser = "user";
    private static final String NEWLINE = "\\n";
    private static final String CONTENT_FIELD_TEXT = "text";
    private static final String CONTENT_FIELD_TYPE = "type";

    private PromptUtil() {
    }

    public static String getQuestionRephrasingPrompt(String originalQuestion, List<Interaction> chatHistory) {
        return null;
    }

    public static String getChatCompletionPrompt(Llm.ModelProvider provider, String question, List<Interaction> chatHistory, List<String> contexts) {
        return PromptUtil.getChatCompletionPrompt(provider, DEFAULT_SYSTEM_PROMPT, null, question, chatHistory, contexts, null);
    }

    public static String getChatCompletionPrompt(Llm.ModelProvider provider, String systemPrompt, String userInstructions, String question, List<Interaction> chatHistory, List<String> contexts, List<MessageBlock> llmMessages) {
        return PromptUtil.buildMessageParameter(provider, systemPrompt, userInstructions, question, chatHistory, contexts, llmMessages);
    }

    public static String buildSingleStringPrompt(String systemPrompt, String userInstructions, String question, List<Interaction> chatHistory, List<String> contexts) {
        if (Strings.isNullOrEmpty((String)systemPrompt) && Strings.isNullOrEmpty((String)userInstructions)) {
            systemPrompt = DEFAULT_SYSTEM_PROMPT;
        }
        StringBuilder bldr = new StringBuilder();
        if (!Strings.isNullOrEmpty((String)systemPrompt)) {
            bldr.append(systemPrompt);
            bldr.append(NEWLINE);
        }
        if (!Strings.isNullOrEmpty((String)userInstructions)) {
            bldr.append(userInstructions);
            bldr.append(NEWLINE);
        }
        for (int i = 0; i < contexts.size(); ++i) {
            bldr.append("SEARCH RESULT " + (i + 1) + ": " + contexts.get(i));
            bldr.append(NEWLINE);
        }
        if (!chatHistory.isEmpty()) {
            List<Message> messages = Messages.fromInteractions(chatHistory).getMessages();
            Collections.reverse(messages);
            messages.forEach(m -> {
                bldr.append(m.toString());
                bldr.append(NEWLINE);
            });
        }
        bldr.append("QUESTION: " + question);
        bldr.append(NEWLINE);
        return bldr.toString();
    }

    static String buildMessageParameter(Llm.ModelProvider provider, String systemPrompt, String userInstructions, String question, List<Interaction> chatHistory, List<String> contexts) {
        return PromptUtil.buildMessageParameter(provider, systemPrompt, userInstructions, question, chatHistory, contexts, null);
    }

    static String buildMessageParameter(Llm.ModelProvider provider, String systemPrompt, String userInstructions, String question, List<Interaction> chatHistory, List<String> contexts, List<MessageBlock> llmMessages) {
        if (Strings.isNullOrEmpty((String)systemPrompt) && Strings.isNullOrEmpty((String)userInstructions)) {
            userInstructions = DEFAULT_SYSTEM_PROMPT;
        }
        MessageArrayBuilder messageArrayBuilder = new MessageArrayBuilder(provider);
        if (!Strings.isNullOrEmpty((String)systemPrompt)) {
            messageArrayBuilder.startMessage(ChatRole.SYSTEM);
            messageArrayBuilder.addTextContent(systemPrompt);
            messageArrayBuilder.endMessage();
        }
        messageArrayBuilder.startMessage(ChatRole.USER);
        boolean lastRoleIsAssistant = false;
        if (!Strings.isNullOrEmpty((String)userInstructions)) {
            messageArrayBuilder.addTextContent(userInstructions);
        }
        for (int i = 0; i < contexts.size(); ++i) {
            messageArrayBuilder.addTextContent("SEARCH RESULT " + (i + 1) + ": " + contexts.get(i));
        }
        if (!chatHistory.isEmpty()) {
            int idx = chatHistory.size() - 1;
            Interaction firstInteraction = chatHistory.get(idx);
            messageArrayBuilder.addTextContent(firstInteraction.getInput());
            messageArrayBuilder.endMessage();
            messageArrayBuilder.startMessage(ChatRole.ASSISTANT, firstInteraction.getResponse());
            messageArrayBuilder.endMessage();
            if (chatHistory.size() > 1) {
                for (int i = --idx; i >= 0; --i) {
                    Interaction interaction = chatHistory.get(i);
                    messageArrayBuilder.startMessage(ChatRole.USER, interaction.getInput());
                    messageArrayBuilder.endMessage();
                    messageArrayBuilder.startMessage(ChatRole.ASSISTANT, interaction.getResponse());
                    messageArrayBuilder.endMessage();
                }
            }
            lastRoleIsAssistant = true;
        }
        if (llmMessages != null && !llmMessages.isEmpty()) {
            if (lastRoleIsAssistant) {
                messageArrayBuilder.startMessage(ChatRole.USER);
            }
            for (MessageBlock message : llmMessages) {
                List<MessageBlock.AbstractBlock> blockList = message.getBlockList();
                for (MessageBlock.Block block : blockList) {
                    switch (block.getType()) {
                        case "text": {
                            messageArrayBuilder.addTextContent(((MessageBlock.TextBlock)block).getText());
                            break;
                        }
                        case "image": {
                            MessageBlock.ImageBlock ib = (MessageBlock.ImageBlock)block;
                            if (ib.getData() != null) {
                                messageArrayBuilder.addImageData(ib.getFormat(), ib.getData());
                                break;
                            }
                            if (ib.getUrl() == null) break;
                            messageArrayBuilder.addImageUrl(ib.getFormat(), ib.getUrl());
                            break;
                        }
                        case "document": {
                            MessageBlock.DocumentBlock db = (MessageBlock.DocumentBlock)block;
                            messageArrayBuilder.addDocumentContent(db.getFormat(), db.getName(), db.getData());
                            break;
                        }
                    }
                }
            }
        } else {
            if (lastRoleIsAssistant) {
                messageArrayBuilder.startMessage(ChatRole.USER, "QUESTION: " + question + "\n");
            } else {
                messageArrayBuilder.addTextContent("QUESTION: " + question + "\n");
            }
            messageArrayBuilder.addTextContent("ANSWER:");
        }
        messageArrayBuilder.endMessage();
        return messageArrayBuilder.toJsonArray().toString();
    }

    public static String getPromptTemplate(String systemPrompt, String userInstructions) {
        return PromptUtil.getPromptTemplateAsJsonArray(systemPrompt, userInstructions).toString();
    }

    static ArrayNode getPromptTemplateAsJsonArray(String systemPrompt, String userInstructions) {
        ObjectMapper mapper = Strings.OBJECT_MAPPER;
        ArrayNode messageArray = mapper.createArrayNode();
        if (!Strings.isNullOrEmpty((String)systemPrompt)) {
            messageArray.add((JsonNode)new Message(ChatRole.SYSTEM, systemPrompt).toJson());
        }
        if (!Strings.isNullOrEmpty((String)userInstructions)) {
            messageArray.add((JsonNode)new Message(ChatRole.USER, userInstructions).toJson());
        }
        return messageArray;
    }

    static class Messages {
        private List<Message> messages = new ArrayList<Message>();

        public Messages(List<Message> messages) {
            this.addMessages(messages);
        }

        public void addMessages(List<Message> messages) {
            this.messages.addAll(messages);
        }

        public static Messages fromInteractions(List<Interaction> interactions) {
            ArrayList<Message> messages = new ArrayList<Message>();
            for (Interaction interaction : interactions) {
                messages.add(new Message(ChatRole.USER, interaction.getInput()));
                messages.add(new Message(ChatRole.ASSISTANT, interaction.getResponse()));
            }
            return new Messages(messages);
        }

        public List<Message> getMessages() {
            return this.messages;
        }
    }

    static class MessageArrayBuilder {
        private final Llm.ModelProvider provider;
        private List<Message> messages = new ArrayList<Message>();
        private Message message = null;
        private Content content = null;

        public MessageArrayBuilder(Llm.ModelProvider provider) {
            if (!EnumSet.of(Llm.ModelProvider.OPENAI, Llm.ModelProvider.BEDROCK_CONVERSE).contains((Object)provider)) {
                throw new IllegalArgumentException("Unsupported provider: " + String.valueOf((Object)provider));
            }
            this.provider = provider;
        }

        public void startMessage(ChatRole role) {
            this.message = new Message();
            this.message.setChatRole(role);
            if (this.provider == Llm.ModelProvider.OPENAI) {
                this.content = new OpenAIContent();
            } else if (this.provider == Llm.ModelProvider.BEDROCK_CONVERSE) {
                this.content = new BedrockContent();
            }
        }

        public void startMessage(ChatRole role, String text) {
            this.startMessage(role);
            this.addTextContent(text);
        }

        public void endMessage() {
            this.message.setContent(this.content);
            this.messages.add(this.message);
            this.message = null;
            this.content = null;
        }

        public void addTextContent(String content) {
            if (this.message == null || this.content == null) {
                throw new RuntimeException("You must call startMessage before calling addTextContent !!");
            }
            this.content.addText(content);
        }

        public void addImageData(String format, String data) {
            if (this.content != null && this.content instanceof ImageContent) {
                ((ImageContent)this.content).addImageData(format, data);
            }
        }

        public void addImageUrl(String format, String url) {
            if (this.content != null && this.content instanceof ImageContent) {
                ((ImageContent)this.content).addImageUrl(format, url);
            }
        }

        public void addDocumentContent(String format, String name, String data) {
            if (this.content != null && this.content instanceof DocumentContent) {
                ((DocumentContent)this.content).addDocument(format, name, data);
            }
        }

        public ArrayNode toJsonArray() {
            if (!(this.message == null && this.content == null)) {
                throw new IllegalStateException("You must call endMessage before calling toJsonArray !!");
            }
            ArrayNode ja = Strings.OBJECT_MAPPER.createArrayNode();
            for (Message message : this.messages) {
                ja.add((JsonNode)message.toJson());
            }
            return ja;
        }
    }

    static enum ChatRole {
        USER("user"),
        ASSISTANT("assistant"),
        SYSTEM("system");

        private String name;

        private ChatRole(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    static class Message {
        private static final String MESSAGE_FIELD_ROLE = "role";
        private static final String MESSAGE_FIELD_CONTENT = "content";
        private ChatRole chatRole;
        private String content;
        private final ObjectNode json = Strings.OBJECT_MAPPER.createObjectNode();

        public Message() {
        }

        public Message(ChatRole chatRole, String content) {
            this();
            this.setChatRole(chatRole);
            this.setContent(content);
        }

        public Message(ChatRole chatRole, Content content) {
            this();
            this.setChatRole(chatRole);
            this.setContent(content);
        }

        public void setChatRole(ChatRole chatRole) {
            this.chatRole = chatRole;
            this.json.remove(MESSAGE_FIELD_ROLE);
            this.json.put(MESSAGE_FIELD_ROLE, chatRole.getName());
        }

        public void setContent(String content) {
            this.content = StringEscapeUtils.escapeJson((String)content);
            this.json.remove(MESSAGE_FIELD_CONTENT);
            this.json.put(MESSAGE_FIELD_CONTENT, this.content);
        }

        public void setContent(Content content) {
            this.json.remove(MESSAGE_FIELD_CONTENT);
            this.json.set(MESSAGE_FIELD_CONTENT, content.toJson());
        }

        public ObjectNode toJson() {
            return this.json;
        }

        public String toString() {
            return String.format(Locale.ROOT, "%s: %s", this.chatRole.getName(), this.content);
        }

        public ChatRole getChatRole() {
            return this.chatRole;
        }

        public String getContent() {
            return this.content;
        }
    }

    static class BedrockContent
    implements MultimodalContent {
        private ArrayNode json = Strings.OBJECT_MAPPER.createArrayNode();

        public BedrockContent() {
        }

        public BedrockContent(String type, String value) {
            this();
            if (type.equals(PromptUtil.CONTENT_FIELD_TEXT)) {
                this.addText(value);
            }
        }

        @Override
        public void addText(String text) {
            ObjectNode content = Strings.OBJECT_MAPPER.createObjectNode();
            content.put(PromptUtil.CONTENT_FIELD_TEXT, text);
            this.json.add((JsonNode)content);
        }

        public ArrayNode toJson() {
            return this.json;
        }

        @Override
        public void addImageData(String format, String data) {
            ObjectNode imageData = Strings.OBJECT_MAPPER.createObjectNode();
            imageData.put("bytes", data);
            ObjectNode image = Strings.OBJECT_MAPPER.createObjectNode();
            image.put("format", format);
            image.set("source", (JsonNode)imageData);
            ObjectNode content = Strings.OBJECT_MAPPER.createObjectNode();
            content.set("image", (JsonNode)image);
            this.json.add((JsonNode)content);
        }

        @Override
        public void addImageUrl(String format, String url) {
        }

        @Override
        public void addDocument(String format, String name, String data) {
            ObjectNode documentData = Strings.OBJECT_MAPPER.createObjectNode();
            documentData.put("bytes", data);
            ObjectNode document = Strings.OBJECT_MAPPER.createObjectNode();
            document.put("format", format);
            document.put("name", name);
            document.set("source", (JsonNode)documentData);
            ObjectNode content = Strings.OBJECT_MAPPER.createObjectNode();
            content.set("document", (JsonNode)document);
            this.json.add((JsonNode)content);
        }
    }

    static class OpenAIContent
    implements ImageContent {
        private ArrayNode json = Strings.OBJECT_MAPPER.createArrayNode();

        @Override
        public void addText(String text) {
            ObjectNode content = Strings.OBJECT_MAPPER.createObjectNode();
            content.put(PromptUtil.CONTENT_FIELD_TYPE, PromptUtil.CONTENT_FIELD_TEXT);
            content.put(PromptUtil.CONTENT_FIELD_TEXT, text);
            this.json.add((JsonNode)content);
        }

        @Override
        public void addImageData(String format, String data) {
            ObjectNode content = Strings.OBJECT_MAPPER.createObjectNode();
            content.put(PromptUtil.CONTENT_FIELD_TYPE, "image_url");
            ObjectNode urlContent = Strings.OBJECT_MAPPER.createObjectNode();
            String imageData = String.format(Locale.ROOT, "data:image/%s;base64,%s", format, data);
            urlContent.put("url", imageData);
            content.set("image_url", (JsonNode)urlContent);
            this.json.add((JsonNode)content);
        }

        @Override
        public void addImageUrl(String format, String url) {
            ObjectNode content = Strings.OBJECT_MAPPER.createObjectNode();
            content.put(PromptUtil.CONTENT_FIELD_TYPE, "image_url");
            ObjectNode urlContent = Strings.OBJECT_MAPPER.createObjectNode();
            urlContent.put("url", url);
            content.set("image_url", (JsonNode)urlContent);
            this.json.add((JsonNode)content);
        }

        public ArrayNode toJson() {
            return this.json;
        }
    }

    static interface MultimodalContent
    extends ImageContent,
    DocumentContent {
    }

    static interface DocumentContent
    extends Content {
        public void addDocument(String var1, String var2, String var3);
    }

    static interface ImageContent
    extends Content {
        public void addImageData(String var1, String var2);

        public void addImageUrl(String var1, String var2);
    }

    static interface Content {
        public void addText(String var1);

        public JsonNode toJson();
    }
}

