/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.stats;

import io.skylite.Version;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentFragment;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.ml.common.stats.ActionName;
import io.skylite.ml.common.stats.MLActionStats;
import io.skylite.ml.common.transport.register.MLRegisterModelInput;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;

public class MLModelStats
implements ToXContentFragment,
Writeable {
    private Map<ActionName, MLActionStats> modelStats;
    private Boolean isHidden;

    public MLModelStats(StreamInput in) throws IOException {
        Version streamInputVersion = in.getVersion();
        if (in.readBoolean()) {
            this.modelStats = in.readMap(stream -> (ActionName)stream.readEnum(ActionName.class), MLActionStats::new);
        }
        if (streamInputVersion.onOrAfter((Version)MLRegisterModelInput.MINIMAL_SUPPORTED_VERSION_FOR_AGENT_FRAMEWORK)) {
            this.isHidden = in.readOptionalBoolean();
        }
    }

    public MLModelStats(Map<ActionName, MLActionStats> modelStats, Boolean isHidden) {
        this.modelStats = modelStats;
        this.isHidden = isHidden;
    }

    public Boolean getIsHidden() {
        return this.isHidden;
    }

    public void writeTo(StreamOutput out) throws IOException {
        Version streamOutputVersion = out.getVersion();
        if (this.modelStats != null && this.modelStats.size() > 0) {
            out.writeBoolean(true);
            out.writeMap(this.modelStats, (stream, v) -> stream.writeEnum((Enum)v), (stream, stats) -> stats.writeTo(stream));
        } else {
            out.writeBoolean(false);
        }
        if (streamOutputVersion.onOrAfter((Version)MLRegisterModelInput.MINIMAL_SUPPORTED_VERSION_FOR_AGENT_FRAMEWORK)) {
            out.writeOptionalBoolean(this.isHidden);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.modelStats != null && this.modelStats.size() > 0) {
            for (Map.Entry<ActionName, MLActionStats> entry : this.modelStats.entrySet()) {
                builder.startObject(entry.getKey().name().toLowerCase(Locale.ROOT));
                entry.getValue().toXContent(builder, params);
                builder.endObject();
            }
        }
        if (this.isHidden != null && this.isHidden.booleanValue()) {
            builder.field("is_hidden", true);
        }
        return builder;
    }

    public MLActionStats getActionStats(ActionName action) {
        return this.modelStats == null ? null : this.modelStats.get((Object)action);
    }
}

