/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.stats;

import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentFragment;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MLPredictRequestStats
implements ToXContentFragment,
Writeable {
    private static final Logger log = LogManager.getLogger(MLPredictRequestStats.class);
    private final Long count;
    private final Double max;
    private final Double min;
    private final Double average;
    private final Double p50;
    private final Double p90;
    private final Double p99;

    public MLPredictRequestStats(long count, Double max, Double min, Double average, Double p50, Double p90, Double p99) {
        this.count = count;
        this.max = max;
        this.min = min;
        this.average = average;
        this.p50 = p50;
        this.p90 = p90;
        this.p99 = p99;
    }

    public MLPredictRequestStats(StreamInput in) throws IOException {
        this.count = in.readOptionalLong();
        this.max = in.readOptionalDouble();
        this.min = in.readOptionalDouble();
        this.average = in.readOptionalDouble();
        this.p50 = in.readOptionalDouble();
        this.p90 = in.readOptionalDouble();
        this.p99 = in.readOptionalDouble();
    }

    public Long getCount() {
        return this.count;
    }

    public double getMax() {
        return this.max;
    }

    public double getMin() {
        return this.min;
    }

    public double getAverage() {
        return this.average;
    }

    public double getP50() {
        return this.p50;
    }

    public double getP90() {
        return this.p90;
    }

    public double getP99() {
        return this.p99;
    }

    public static Builder builder() {
        return new Builder();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.count != null) {
            builder.field("count", this.count);
        }
        if (this.max != null) {
            builder.field("max", this.max);
        }
        if (this.min != null) {
            builder.field("min", this.min);
        }
        if (this.average != null) {
            builder.field("average", this.average);
        }
        if (this.p50 != null) {
            builder.field("p50", this.p50);
        }
        if (this.p90 != null) {
            builder.field("p90", this.p90);
        }
        if (this.p99 != null) {
            builder.field("p99", this.p99);
        }
        builder.endObject();
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalLong(this.count);
        out.writeOptionalDouble(this.max);
        out.writeOptionalDouble(this.min);
        out.writeOptionalDouble(this.average);
        out.writeOptionalDouble(this.p50);
        out.writeOptionalDouble(this.p90);
        out.writeOptionalDouble(this.p99);
    }

    public static class Builder {
        private long count;
        private Double max;
        private Double min;
        private Double average;
        private Double p50;
        private Double p90;
        private Double p99;

        public Builder count(long count) {
            this.count = count;
            return this;
        }

        public Builder max(Double max) {
            this.max = max;
            return this;
        }

        public Builder min(Double min) {
            this.min = min;
            return this;
        }

        public Builder average(Double average) {
            this.average = average;
            return this;
        }

        public Builder p50(Double p50) {
            this.p50 = p50;
            return this;
        }

        public Builder p90(Double p90) {
            this.p90 = p90;
            return this;
        }

        public Builder p99(Double p99) {
            this.p99 = p99;
            return this;
        }

        public MLPredictRequestStats build() {
            return new MLPredictRequestStats(this.count, this.max, this.min, this.average, this.p50, this.p90, this.p99);
        }
    }
}

