/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.stats;

import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.ml.common.FunctionName;
import io.skylite.ml.common.cluster.MLNodeUtils;
import io.skylite.ml.common.stats.ActionName;
import io.skylite.ml.common.stats.MLActionLevelStat;
import io.skylite.ml.common.stats.MLClusterLevelStat;
import io.skylite.ml.common.stats.MLNodeLevelStat;
import io.skylite.ml.common.stats.MLStatLevel;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public class MLStatsInput
implements ToXContentObject,
Writeable {
    public static final String TARGET_STAT_LEVEL = "target_stat_levels";
    public static final String CLUSTER_LEVEL_STATS = "cluster_level_stats";
    public static final String NODE_LEVEL_STATS = "node_level_stats";
    public static final String ACTION_LEVEL_STATS = "action_level_stats";
    public static final String NODE_IDS = "node_ids";
    public static final String ALGORITHMS = "algorithms";
    public static final String MODELS = "models";
    public static final String ACTIONS = "actions";
    private EnumSet<MLStatLevel> targetStatLevels;
    private EnumSet<MLClusterLevelStat> clusterLevelStats;
    private EnumSet<MLNodeLevelStat> nodeLevelStats;
    private EnumSet<MLActionLevelStat> actionLevelStats;
    private Set<String> nodeIds;
    private EnumSet<FunctionName> algorithms;
    private Set<String> models;
    private EnumSet<ActionName> actions;

    public MLStatsInput(EnumSet<MLStatLevel> targetStatLevels, EnumSet<MLClusterLevelStat> clusterLevelStats, EnumSet<MLNodeLevelStat> nodeLevelStats, EnumSet<MLActionLevelStat> actionLevelStats, Set<String> nodeIds, EnumSet<FunctionName> algorithms, Set<String> models, EnumSet<ActionName> actions) {
        this.targetStatLevels = targetStatLevels;
        this.clusterLevelStats = clusterLevelStats;
        this.nodeLevelStats = nodeLevelStats;
        this.actionLevelStats = actionLevelStats;
        this.nodeIds = nodeIds;
        this.algorithms = algorithms;
        this.models = models;
        this.actions = actions;
    }

    public MLStatsInput() {
        this.targetStatLevels = EnumSet.noneOf(MLStatLevel.class);
        this.clusterLevelStats = EnumSet.noneOf(MLClusterLevelStat.class);
        this.nodeLevelStats = EnumSet.noneOf(MLNodeLevelStat.class);
        this.actionLevelStats = EnumSet.noneOf(MLActionLevelStat.class);
        this.nodeIds = new HashSet<String>();
        this.algorithms = EnumSet.noneOf(FunctionName.class);
        this.models = new HashSet<String>();
        this.actions = EnumSet.noneOf(ActionName.class);
    }

    public MLStatsInput(StreamInput input) throws IOException {
        this.targetStatLevels = input.readBoolean() ? input.readEnumSet(MLStatLevel.class) : EnumSet.noneOf(MLStatLevel.class);
        this.clusterLevelStats = input.readBoolean() ? input.readEnumSet(MLClusterLevelStat.class) : EnumSet.noneOf(MLClusterLevelStat.class);
        this.nodeLevelStats = input.readBoolean() ? input.readEnumSet(MLNodeLevelStat.class) : EnumSet.noneOf(MLNodeLevelStat.class);
        this.actionLevelStats = input.readBoolean() ? input.readEnumSet(MLActionLevelStat.class) : EnumSet.noneOf(MLActionLevelStat.class);
        this.nodeIds = input.readBoolean() ? new HashSet(input.readStringList()) : new HashSet();
        this.models = input.readBoolean() ? new HashSet(input.readStringList()) : new HashSet();
        this.algorithms = input.readBoolean() ? input.readEnumSet(FunctionName.class) : EnumSet.noneOf(FunctionName.class);
        this.actions = input.readBoolean() ? input.readEnumSet(ActionName.class) : EnumSet.noneOf(ActionName.class);
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.writeEnumSet(out, this.targetStatLevels);
        this.writeEnumSet(out, this.clusterLevelStats);
        this.writeEnumSet(out, this.nodeLevelStats);
        this.writeEnumSet(out, this.actionLevelStats);
        out.writeOptionalStringCollection(this.nodeIds);
        out.writeOptionalStringCollection(this.models);
        this.writeEnumSet(out, this.algorithms);
        this.writeEnumSet(out, this.actions);
    }

    private void writeEnumSet(StreamOutput out, EnumSet<?> set) throws IOException {
        if (set != null && set.size() > 0) {
            out.writeBoolean(true);
            out.writeEnumSet(set);
        } else {
            out.writeBoolean(false);
        }
    }

    public static MLStatsInput parse(XContentParser parser) throws IOException {
        EnumSet<MLStatLevel> targetStatLevels = EnumSet.noneOf(MLStatLevel.class);
        EnumSet<MLClusterLevelStat> clusterLevelStats = EnumSet.noneOf(MLClusterLevelStat.class);
        EnumSet<MLNodeLevelStat> nodeLevelStats = EnumSet.noneOf(MLNodeLevelStat.class);
        EnumSet<MLActionLevelStat> actionLevelStats = EnumSet.noneOf(MLActionLevelStat.class);
        HashSet<String> nodeIds = new HashSet<String>();
        HashSet<String> models = new HashSet<String>();
        EnumSet<FunctionName> algorithms = EnumSet.noneOf(FunctionName.class);
        EnumSet<ActionName> actions = EnumSet.noneOf(ActionName.class);
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block20: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "target_stat_levels": {
                    MLNodeUtils.parseField(parser, targetStatLevels, input -> MLStatLevel.from(input.toUpperCase(Locale.ROOT)), MLStatLevel.class);
                    continue block20;
                }
                case "cluster_level_stats": {
                    MLNodeUtils.parseField(parser, clusterLevelStats, input -> MLClusterLevelStat.from(input.toUpperCase(Locale.ROOT)), MLClusterLevelStat.class);
                    continue block20;
                }
                case "node_level_stats": {
                    MLNodeUtils.parseField(parser, nodeLevelStats, input -> MLNodeLevelStat.from(input.toUpperCase(Locale.ROOT)), MLNodeLevelStat.class);
                    continue block20;
                }
                case "action_level_stats": {
                    MLNodeUtils.parseField(parser, actionLevelStats, input -> MLActionLevelStat.from(input.toUpperCase(Locale.ROOT)), MLActionLevelStat.class);
                    continue block20;
                }
                case "node_ids": {
                    MLNodeUtils.parseArrayField(parser, nodeIds);
                    continue block20;
                }
                case "algorithms": {
                    MLNodeUtils.parseField(parser, algorithms, input -> FunctionName.from(input.toUpperCase(Locale.ROOT)), FunctionName.class);
                    continue block20;
                }
                case "models": {
                    MLNodeUtils.parseArrayField(parser, models);
                    continue block20;
                }
                case "actions": {
                    MLNodeUtils.parseField(parser, actions, input -> ActionName.from(input.toUpperCase(Locale.ROOT)), ActionName.class);
                    continue block20;
                }
            }
            parser.skipChildren();
        }
        return MLStatsInput.builder().targetStatLevels(targetStatLevels).clusterLevelStats(clusterLevelStats).nodeLevelStats(nodeLevelStats).actionLevelStats(actionLevelStats).nodeIds(nodeIds).algorithms(algorithms).models(models).actions(actions).build();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.targetStatLevels != null) {
            builder.field(TARGET_STAT_LEVEL, this.targetStatLevels);
        }
        if (this.clusterLevelStats != null) {
            builder.field(CLUSTER_LEVEL_STATS, this.clusterLevelStats);
        }
        if (this.nodeLevelStats != null) {
            builder.field(NODE_LEVEL_STATS, this.nodeLevelStats);
        }
        if (this.actionLevelStats != null) {
            builder.field(ACTION_LEVEL_STATS, this.actionLevelStats);
        }
        if (this.nodeIds != null) {
            builder.field(NODE_IDS, this.nodeIds);
        }
        if (this.algorithms != null) {
            builder.field(ALGORITHMS, this.algorithms);
        }
        if (this.models != null) {
            builder.field(MODELS, this.models);
        }
        if (this.actions != null) {
            builder.field(ACTIONS, this.actions);
        }
        builder.endObject();
        return builder;
    }

    public boolean retrieveAllClusterLevelStats() {
        return this.clusterLevelStats == null || this.clusterLevelStats.size() == 0;
    }

    public boolean retrieveAllNodeLevelStats() {
        return this.nodeLevelStats == null || this.nodeLevelStats.size() == 0;
    }

    public boolean retrieveAllActionLevelStats() {
        return this.actionLevelStats == null || this.actionLevelStats.size() == 0;
    }

    public boolean retrieveStatsOnAllNodes() {
        return this.nodeIds == null || this.nodeIds.size() == 0;
    }

    public boolean retrieveStatsForAllAlgos() {
        return this.algorithms == null || this.algorithms.size() == 0;
    }

    public boolean retrieveStatsForAllModels() {
        return this.models == null || this.models.size() == 0;
    }

    public boolean retrieveStatsForAlgo(FunctionName algoName) {
        return this.retrieveStatsForAllAlgos() || this.algorithms.contains((Object)algoName);
    }

    public boolean retrieveStatsForModel(String modelId) {
        return this.retrieveStatsForAllModels() || this.models.contains(modelId);
    }

    public boolean retrieveStatsForAction(ActionName actionName) {
        return this.retrieveStatsForAllActions() || this.actions.contains((Object)actionName);
    }

    public boolean retrieveStatsForAllActions() {
        return this.actions == null || this.actions.size() == 0;
    }

    public boolean retrieveStat(Enum<?> key) {
        if (key instanceof MLClusterLevelStat) {
            return this.retrieveAllClusterLevelStats() || this.clusterLevelStats.contains(key);
        }
        if (key instanceof MLNodeLevelStat) {
            return this.retrieveAllNodeLevelStats() || this.nodeLevelStats.contains(key);
        }
        if (key instanceof MLActionLevelStat) {
            return this.retrieveAllActionLevelStats() || this.actionLevelStats.contains(key);
        }
        return false;
    }

    public boolean onlyRetrieveClusterLevelStats() {
        if (this.targetStatLevels == null || this.targetStatLevels.size() == 0) {
            return false;
        }
        return !this.targetStatLevels.contains((Object)MLStatLevel.NODE) && !this.targetStatLevels.contains((Object)MLStatLevel.ALGORITHM) && !this.targetStatLevels.contains((Object)MLStatLevel.MODEL) && !this.targetStatLevels.contains((Object)MLStatLevel.ACTION);
    }

    public boolean includeAlgoStats() {
        return this.targetStatLevels.contains((Object)MLStatLevel.ALGORITHM) || this.targetStatLevels.contains((Object)MLStatLevel.ACTION);
    }

    public boolean includeModelStats() {
        return this.targetStatLevels.contains((Object)MLStatLevel.MODEL) || this.targetStatLevels.contains((Object)MLStatLevel.ACTION);
    }

    public EnumSet<MLStatLevel> getTargetStatLevels() {
        return this.targetStatLevels;
    }

    public EnumSet<MLClusterLevelStat> getClusterLevelStats() {
        return this.clusterLevelStats;
    }

    public EnumSet<MLNodeLevelStat> getNodeLevelStats() {
        return this.nodeLevelStats;
    }

    public EnumSet<MLActionLevelStat> getActionLevelStats() {
        return this.actionLevelStats;
    }

    public Set<String> getNodeIds() {
        return this.nodeIds;
    }

    public EnumSet<FunctionName> getAlgorithms() {
        return this.algorithms;
    }

    public Set<String> getModels() {
        return this.models;
    }

    public EnumSet<ActionName> getActions() {
        return this.actions;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private EnumSet<MLStatLevel> targetStatLevels;
        private EnumSet<MLClusterLevelStat> clusterLevelStats;
        private EnumSet<MLNodeLevelStat> nodeLevelStats;
        private EnumSet<MLActionLevelStat> actionLevelStats;
        private Set<String> nodeIds;
        private EnumSet<FunctionName> algorithms;
        private Set<String> models;
        private EnumSet<ActionName> actions;

        public Builder targetStatLevels(EnumSet<MLStatLevel> targetStatLevels) {
            this.targetStatLevels = targetStatLevels;
            return this;
        }

        public Builder clusterLevelStats(EnumSet<MLClusterLevelStat> clusterLevelStats) {
            this.clusterLevelStats = clusterLevelStats;
            return this;
        }

        public Builder nodeLevelStats(EnumSet<MLNodeLevelStat> nodeLevelStats) {
            this.nodeLevelStats = nodeLevelStats;
            return this;
        }

        public Builder actionLevelStats(EnumSet<MLActionLevelStat> actionLevelStats) {
            this.actionLevelStats = actionLevelStats;
            return this;
        }

        public Builder nodeIds(Set<String> nodeIds) {
            this.nodeIds = nodeIds;
            return this;
        }

        public Builder algorithms(EnumSet<FunctionName> algorithms) {
            this.algorithms = algorithms;
            return this;
        }

        public Builder models(Set<String> models) {
            this.models = models;
            return this;
        }

        public Builder actions(EnumSet<ActionName> actions) {
            this.actions = actions;
            return this;
        }

        public MLStatsInput build() {
            return new MLStatsInput(this.targetStatLevels, this.clusterLevelStats, this.nodeLevelStats, this.actionLevelStats, this.nodeIds, this.algorithms, this.models, this.actions);
        }
    }
}

