/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.task;

import io.skylite.ml.common.task.MLTask;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;

public class MLTaskCache {
    protected MLTask mlTask;
    protected Semaphore updateTaskIndexSemaphore;
    protected Set<String> workerNodes;
    protected Map<String, String> errors;
    protected Integer workerNodeSize;

    public MLTaskCache(MLTask mlTask, List<String> workerNodes) {
        this.mlTask = mlTask;
        if (mlTask.isAsync()) {
            this.updateTaskIndexSemaphore = new Semaphore(1);
        }
        this.workerNodes = ConcurrentHashMap.newKeySet();
        if (workerNodes != null) {
            this.workerNodes.addAll(workerNodes);
            this.workerNodeSize = workerNodes.size();
        }
        this.errors = new ConcurrentHashMap<String, String>();
    }

    public MLTaskCache(MLTask mlTask) {
        this(mlTask, null);
    }

    public MLTask getMlTask() {
        return this.mlTask;
    }

    public Semaphore getUpdateTaskIndexSemaphore() {
        return this.updateTaskIndexSemaphore;
    }

    public Set<String> getWorkerNodes() {
        return this.workerNodes;
    }

    public Map<String, String> getErrors() {
        return this.errors;
    }

    public Integer getWorkerNodeSize() {
        return this.workerNodeSize;
    }

    public void addError(String nodeId, String error) {
        this.errors.put(nodeId, error);
    }

    public boolean hasError() {
        return this.errors.size() > 0;
    }

    public int errorNodesCount() {
        return this.errors.size();
    }

    public boolean allNodeFailed() {
        return this.workerNodeSize != null && this.errors.size() == this.workerNodeSize.intValue();
    }

    public void updateWorkerNode(Set<String> nodesRemovedFromCluster) {
        this.workerNodes.removeAll(nodesRemovedFromCluster);
        this.workerNodeSize = this.workerNodeSize - nodesRemovedFromCluster.size();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        protected MLTask mlTask;
        protected List<String> workerNodes;

        public Builder mlTask(MLTask mlTask) {
            this.mlTask = mlTask;
            return this;
        }

        public Builder workerNodes(List<String> workerNodes) {
            this.workerNodes = workerNodes;
            return this;
        }

        public MLTaskCache build() {
            return new MLTaskCache(this.mlTask, this.workerNodes);
        }
    }
}

