/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.transport.chunk;

import io.skylite.Version;
import io.skylite.core.common.Strings;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.ml.common.AccessMode;
import io.skylite.ml.common.FunctionName;
import io.skylite.ml.common.controller.MLRateLimiter;
import io.skylite.ml.common.model.MLDeploySetting;
import io.skylite.ml.common.model.MLModel;
import io.skylite.ml.common.model.MLModelConfig;
import io.skylite.ml.common.model.MLModelFormat;
import io.skylite.ml.common.model.MLModelState;
import io.skylite.ml.common.model.QuestionAnsweringModelConfig;
import io.skylite.ml.common.model.TextEmbeddingModelConfig;
import io.skylite.ml.common.transport.register.MLRegisterModelInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class MLRegisterModelMetaInput
implements ToXContentObject,
Writeable {
    public static final String FUNCTION_NAME_FIELD = "function_name";
    public static final String MODEL_NAME_FIELD = "name";
    public static final String DESCRIPTION_FIELD = "description";
    public static final String IS_ENABLED_FIELD = "is_enabled";
    public static final String RATE_LIMITER_FIELD = "rate_limiter";
    public static final String VERSION_FIELD = "version";
    public static final String MODEL_FORMAT_FIELD = "model_format";
    public static final String MODEL_STATE_FIELD = "model_state";
    public static final String MODEL_CONTENT_SIZE_IN_BYTES_FIELD = "model_content_size_in_bytes";
    public static final String MODEL_CONTENT_HASH_VALUE_FIELD = "model_content_hash_value";
    public static final String MODEL_CONFIG_FIELD = "model_config";
    public static final String DEPLOY_SETTING_FIELD = "deploy_setting";
    public static final String TOTAL_CHUNKS_FIELD = "total_chunks";
    public static final String MODEL_GROUP_ID_FIELD = "model_group_id";
    public static final String BACKEND_ROLES_FIELD = "backend_roles";
    public static final String ACCESS_MODE = "access_mode";
    public static final String ADD_ALL_BACKEND_ROLES = "add_all_backend_roles";
    public static final String DOES_VERSION_CREATE_MODEL_GROUP = "does_version_create_model_group";
    private FunctionName functionName;
    private String name;
    private String modelGroupId;
    private String description;
    private String version;
    private Boolean isEnabled;
    private MLRateLimiter rateLimiter;
    private MLModelFormat modelFormat;
    private MLModelState modelState;
    private Long modelContentSizeInBytes;
    private String modelContentHashValue;
    private MLModelConfig modelConfig;
    private MLDeploySetting deploySetting;
    private Integer totalChunks;
    private List<String> backendRoles;
    private AccessMode accessMode;
    private Boolean isAddAllBackendRoles;
    private Boolean doesVersionCreateModelGroup;
    private Boolean isHidden;
    private Map<String, String> modelInterface;

    public MLRegisterModelMetaInput(String name, FunctionName functionName, String modelGroupId, String version, String description, Boolean isEnabled, MLRateLimiter rateLimiter, MLModelFormat modelFormat, MLModelState modelState, Long modelContentSizeInBytes, String modelContentHashValue, MLModelConfig modelConfig, MLDeploySetting deploySetting, Integer totalChunks, List<String> backendRoles, AccessMode accessMode, Boolean isAddAllBackendRoles, Boolean doesVersionCreateModelGroup, Boolean isHidden, Map<String, String> modelInterface) {
        if (name == null) {
            throw new IllegalArgumentException("model name is null");
        }
        this.functionName = functionName == null ? FunctionName.TEXT_EMBEDDING : functionName;
        if (modelFormat == null) {
            throw new IllegalArgumentException("model format is null");
        }
        if (modelContentHashValue == null) {
            throw new IllegalArgumentException("model content hash value is null");
        }
        if (modelConfig == null && functionName != FunctionName.SPARSE_TOKENIZE && functionName != FunctionName.SPARSE_ENCODING) {
            throw new IllegalArgumentException("model config is null");
        }
        if (totalChunks == null) {
            throw new IllegalArgumentException("total chunks field is null");
        }
        this.name = name;
        this.modelGroupId = modelGroupId;
        this.version = version;
        this.description = description;
        this.isEnabled = isEnabled;
        this.rateLimiter = rateLimiter;
        this.modelFormat = modelFormat;
        this.modelState = modelState;
        this.modelContentSizeInBytes = modelContentSizeInBytes;
        this.modelContentHashValue = modelContentHashValue;
        this.modelConfig = modelConfig;
        this.deploySetting = deploySetting;
        this.totalChunks = totalChunks;
        this.backendRoles = backendRoles;
        this.accessMode = accessMode;
        this.isAddAllBackendRoles = isAddAllBackendRoles;
        this.doesVersionCreateModelGroup = doesVersionCreateModelGroup;
        this.isHidden = isHidden;
        this.modelInterface = modelInterface;
    }

    public MLRegisterModelMetaInput(StreamInput in) throws IOException {
        Version streamInputVersion = in.getVersion();
        this.name = in.readString();
        this.functionName = (FunctionName)in.readEnum(FunctionName.class);
        this.modelGroupId = in.readOptionalString();
        this.version = in.readOptionalString();
        this.description = in.readOptionalString();
        if (in.readBoolean()) {
            this.modelFormat = (MLModelFormat)in.readEnum(MLModelFormat.class);
        }
        if (in.readBoolean()) {
            this.modelState = (MLModelState)in.readEnum(MLModelState.class);
        }
        this.modelContentSizeInBytes = in.readOptionalLong();
        this.modelContentHashValue = in.readString();
        if (in.readBoolean()) {
            this.modelConfig = this.functionName.equals((Object)FunctionName.QUESTION_ANSWERING) ? new QuestionAnsweringModelConfig(in) : new TextEmbeddingModelConfig(in);
        }
        this.totalChunks = in.readInt();
        this.backendRoles = in.readOptionalStringList();
        if (in.readBoolean()) {
            this.accessMode = (AccessMode)in.readEnum(AccessMode.class);
        }
        this.isAddAllBackendRoles = in.readOptionalBoolean();
        if (streamInputVersion.onOrAfter((Version)MLRegisterModelInput.MINIMAL_SUPPORTED_VERSION_FOR_DOES_VERSION_CREATE_MODEL_GROUP)) {
            this.doesVersionCreateModelGroup = in.readOptionalBoolean();
        }
        if (streamInputVersion.onOrAfter((Version)MLRegisterModelInput.MINIMAL_SUPPORTED_VERSION_FOR_AGENT_FRAMEWORK)) {
            this.isEnabled = in.readOptionalBoolean();
            if (in.readBoolean()) {
                this.rateLimiter = new MLRateLimiter(in);
            }
            this.isHidden = in.readOptionalBoolean();
        }
        if (streamInputVersion.onOrAfter((Version)MLRegisterModelInput.MINIMAL_SUPPORTED_VERSION_FOR_GUARDRAILS_AND_AUTO_DEPLOY) && in.readBoolean()) {
            this.deploySetting = new MLDeploySetting(in);
        }
        if (streamInputVersion.onOrAfter((Version)MLRegisterModelInput.MINIMAL_SUPPORTED_VERSION_FOR_INTERFACE) && in.readBoolean()) {
            this.modelInterface = in.readMap(StreamInput::readString, StreamInput::readString);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public void writeTo(StreamOutput out) throws IOException {
        Version streamOutputVersion = out.getVersion();
        out.writeString(this.name);
        out.writeEnum((Enum)this.functionName);
        out.writeOptionalString(this.modelGroupId);
        out.writeOptionalString(this.version);
        out.writeOptionalString(this.description);
        if (this.modelFormat != null) {
            out.writeBoolean(true);
            out.writeEnum((Enum)this.modelFormat);
        } else {
            out.writeBoolean(false);
        }
        if (this.modelState != null) {
            out.writeBoolean(true);
            out.writeEnum((Enum)this.modelState);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalLong(this.modelContentSizeInBytes);
        out.writeString(this.modelContentHashValue);
        if (this.modelConfig != null) {
            out.writeBoolean(true);
            this.modelConfig.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeInt(this.totalChunks.intValue());
        if (this.backendRoles != null) {
            out.writeBoolean(true);
            out.writeStringCollection(this.backendRoles);
        } else {
            out.writeBoolean(false);
        }
        if (this.accessMode != null) {
            out.writeBoolean(true);
            out.writeEnum((Enum)this.accessMode);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalBoolean(this.isAddAllBackendRoles);
        if (streamOutputVersion.onOrAfter((Version)MLRegisterModelInput.MINIMAL_SUPPORTED_VERSION_FOR_DOES_VERSION_CREATE_MODEL_GROUP)) {
            out.writeOptionalBoolean(this.doesVersionCreateModelGroup);
        }
        if (streamOutputVersion.onOrAfter((Version)MLRegisterModelInput.MINIMAL_SUPPORTED_VERSION_FOR_AGENT_FRAMEWORK)) {
            out.writeOptionalBoolean(this.isEnabled);
            if (this.rateLimiter != null) {
                out.writeBoolean(true);
                this.rateLimiter.writeTo(out);
            } else {
                out.writeBoolean(false);
            }
            out.writeOptionalBoolean(this.isHidden);
        }
        if (streamOutputVersion.onOrAfter((Version)MLRegisterModelInput.MINIMAL_SUPPORTED_VERSION_FOR_GUARDRAILS_AND_AUTO_DEPLOY)) {
            if (this.deploySetting != null) {
                out.writeBoolean(true);
                this.deploySetting.writeTo(out);
            } else {
                out.writeBoolean(false);
            }
        }
        if (streamOutputVersion.onOrAfter((Version)MLRegisterModelInput.MINIMAL_SUPPORTED_VERSION_FOR_INTERFACE)) {
            if (this.modelInterface != null) {
                out.writeBoolean(true);
                out.writeMap(this.modelInterface, StreamOutput::writeString, StreamOutput::writeString);
            } else {
                out.writeBoolean(false);
            }
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(MODEL_NAME_FIELD, this.name);
        builder.field(FUNCTION_NAME_FIELD, (Object)this.functionName);
        if (this.modelGroupId != null) {
            builder.field(MODEL_GROUP_ID_FIELD, this.modelGroupId);
        }
        if (this.version != null) {
            builder.field(VERSION_FIELD, this.version);
        }
        if (this.description != null) {
            builder.field(DESCRIPTION_FIELD, this.description);
        }
        if (this.isEnabled != null) {
            builder.field(IS_ENABLED_FIELD, this.isEnabled);
        }
        if (this.rateLimiter != null) {
            builder.field(RATE_LIMITER_FIELD, (ToXContent)this.rateLimiter);
        }
        builder.field(MODEL_FORMAT_FIELD, (Object)this.modelFormat);
        if (this.modelState != null) {
            builder.field(MODEL_STATE_FIELD, (Object)this.modelState);
        }
        if (this.modelContentSizeInBytes != null) {
            builder.field(MODEL_CONTENT_SIZE_IN_BYTES_FIELD, this.modelContentSizeInBytes);
        }
        builder.field(MODEL_CONTENT_HASH_VALUE_FIELD, this.modelContentHashValue);
        builder.field(MODEL_CONFIG_FIELD, (ToXContent)this.modelConfig);
        builder.field(TOTAL_CHUNKS_FIELD, this.totalChunks);
        if (this.deploySetting != null) {
            builder.field(DEPLOY_SETTING_FIELD, (ToXContent)this.deploySetting);
        }
        if (this.backendRoles != null && this.backendRoles.size() > 0) {
            builder.field(BACKEND_ROLES_FIELD, this.backendRoles);
        }
        if (this.accessMode != null) {
            builder.field(ACCESS_MODE, (Object)this.accessMode);
        }
        if (this.isAddAllBackendRoles != null) {
            builder.field(ADD_ALL_BACKEND_ROLES, this.isAddAllBackendRoles);
        }
        if (this.doesVersionCreateModelGroup != null) {
            builder.field(DOES_VERSION_CREATE_MODEL_GROUP, this.doesVersionCreateModelGroup);
        }
        if (this.isHidden != null) {
            builder.field("is_hidden", this.isHidden);
        }
        if (this.modelInterface != null) {
            builder.field("interface", this.modelInterface);
        }
        builder.endObject();
        return builder;
    }

    public static MLRegisterModelMetaInput parse(XContentParser parser) throws IOException {
        String name = null;
        FunctionName functionName = null;
        String modelGroupId = null;
        String version = null;
        String description = null;
        Boolean isEnabled = null;
        MLRateLimiter rateLimiter = null;
        MLModelFormat modelFormat = null;
        MLModelState modelState = null;
        Long modelContentSizeInBytes = null;
        String modelContentHashValue = null;
        MLModelConfig modelConfig = null;
        MLDeploySetting deploySetting = null;
        Integer totalChunks = null;
        ArrayList<String> backendRoles = null;
        AccessMode accessMode = null;
        Boolean isAddAllBackendRoles = null;
        Boolean doesVersionCreateModelGroup = null;
        Boolean isHidden = null;
        Map modelInterface = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block44: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            if (fieldName == null) {
                parser.skipChildren();
                continue;
            }
            switch (fieldName) {
                case "name": {
                    name = parser.text();
                    continue block44;
                }
                case "function_name": {
                    functionName = FunctionName.from(parser.text());
                    continue block44;
                }
                case "model_group_id": {
                    modelGroupId = parser.text();
                    continue block44;
                }
                case "version": {
                    version = parser.text();
                    continue block44;
                }
                case "description": {
                    description = parser.text();
                    continue block44;
                }
                case "is_enabled": {
                    isEnabled = parser.booleanValue();
                    continue block44;
                }
                case "rate_limiter": {
                    rateLimiter = MLRateLimiter.parse(parser);
                    continue block44;
                }
                case "model_format": {
                    modelFormat = MLModelFormat.from(parser.text());
                    continue block44;
                }
                case "model_state": {
                    modelState = MLModelState.from(parser.text());
                    continue block44;
                }
                case "model_content_size_in_bytes": {
                    modelContentSizeInBytes = parser.longValue();
                    continue block44;
                }
                case "model_content_hash_value": {
                    modelContentHashValue = parser.text();
                    continue block44;
                }
                case "model_config": {
                    if (FunctionName.QUESTION_ANSWERING.equals((Object)functionName)) {
                        modelConfig = QuestionAnsweringModelConfig.parse(parser);
                        continue block44;
                    }
                    modelConfig = TextEmbeddingModelConfig.parse(parser);
                    continue block44;
                }
                case "deploy_setting": {
                    deploySetting = MLDeploySetting.parse(parser);
                    continue block44;
                }
                case "total_chunks": {
                    totalChunks = parser.intValue(false);
                    continue block44;
                }
                case "backend_roles": {
                    backendRoles = new ArrayList<String>();
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        backendRoles.add(parser.text());
                    }
                    continue block44;
                }
                case "access_mode": {
                    accessMode = AccessMode.from(parser.text().toLowerCase(Locale.ROOT));
                    continue block44;
                }
                case "add_all_backend_roles": {
                    isAddAllBackendRoles = parser.booleanValue();
                    continue block44;
                }
                case "does_version_create_model_group": {
                    doesVersionCreateModelGroup = parser.booleanValue();
                    continue block44;
                }
                case "is_hidden": {
                    isHidden = parser.booleanValue();
                    continue block44;
                }
                case "interface": {
                    modelInterface = Strings.filteredParameterMap((Map)parser.map(), MLModel.allowedInterfaceFieldKeys);
                    continue block44;
                }
            }
            parser.skipChildren();
        }
        return new MLRegisterModelMetaInput(name, functionName, modelGroupId, version, description, isEnabled, rateLimiter, modelFormat, modelState, modelContentSizeInBytes, modelContentHashValue, modelConfig, deploySetting, totalChunks, backendRoles, accessMode, isAddAllBackendRoles, doesVersionCreateModelGroup, isHidden, modelInterface);
    }

    public FunctionName getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(FunctionName functionName) {
        this.functionName = functionName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getModelGroupId() {
        return this.modelGroupId;
    }

    public void setModelGroupId(String modelGroupId) {
        this.modelGroupId = modelGroupId;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    public void setIsEnabled(Boolean enabled) {
        this.isEnabled = enabled;
    }

    public MLRateLimiter getRateLimiter() {
        return this.rateLimiter;
    }

    public void setRateLimiter(MLRateLimiter rateLimiter) {
        this.rateLimiter = rateLimiter;
    }

    public MLModelFormat getModelFormat() {
        return this.modelFormat;
    }

    public void setModelFormat(MLModelFormat modelFormat) {
        this.modelFormat = modelFormat;
    }

    public MLModelState getModelState() {
        return this.modelState;
    }

    public void setModelState(MLModelState modelState) {
        this.modelState = modelState;
    }

    public Long getModelContentSizeInBytes() {
        return this.modelContentSizeInBytes;
    }

    public void setModelContentSizeInBytes(Long modelContentSizeInBytes) {
        this.modelContentSizeInBytes = modelContentSizeInBytes;
    }

    public String getModelContentHashValue() {
        return this.modelContentHashValue;
    }

    public void setModelContentHashValue(String modelContentHashValue) {
        this.modelContentHashValue = modelContentHashValue;
    }

    public MLModelConfig getModelConfig() {
        return this.modelConfig;
    }

    public void setModelConfig(MLModelConfig modelConfig) {
        this.modelConfig = modelConfig;
    }

    public MLDeploySetting getDeploySetting() {
        return this.deploySetting;
    }

    public void setDeploySetting(MLDeploySetting deploySetting) {
        this.deploySetting = deploySetting;
    }

    public Integer getTotalChunks() {
        return this.totalChunks;
    }

    public void setTotalChunks(Integer totalChunks) {
        this.totalChunks = totalChunks;
    }

    public List<String> getBackendRoles() {
        return this.backendRoles;
    }

    public void setBackendRoles(List<String> backendRoles) {
        this.backendRoles = backendRoles;
    }

    public AccessMode getAccessMode() {
        return this.accessMode;
    }

    public void setAccessMode(AccessMode accessMode) {
        this.accessMode = accessMode;
    }

    public Boolean getAddAllBackendRoles() {
        return this.isAddAllBackendRoles;
    }

    public void setAddAllBackendRoles(Boolean addAllBackendRoles) {
        this.isAddAllBackendRoles = addAllBackendRoles;
    }

    public Boolean getDoesVersionCreateModelGroup() {
        return this.doesVersionCreateModelGroup;
    }

    public void setDoesVersionCreateModelGroup(Boolean doesVersionCreateModelGroup) {
        this.doesVersionCreateModelGroup = doesVersionCreateModelGroup;
    }

    public Boolean getIsHidden() {
        return this.isHidden;
    }

    public void setIsHidden(Boolean hidden) {
        this.isHidden = hidden;
    }

    public Map<String, String> getModelInterface() {
        return this.modelInterface;
    }

    public void setModelInterface(Map<String, String> modelInterface) {
        this.modelInterface = modelInterface;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MLRegisterModelMetaInput that = (MLRegisterModelMetaInput)o;
        return this.functionName == that.functionName && Objects.equals(this.name, that.name) && Objects.equals(this.modelGroupId, that.modelGroupId) && Objects.equals(this.description, that.description) && Objects.equals(this.version, that.version) && Objects.equals(this.isEnabled, that.isEnabled) && Objects.equals(this.rateLimiter, that.rateLimiter) && this.modelFormat == that.modelFormat && this.modelState == that.modelState && Objects.equals(this.modelContentSizeInBytes, that.modelContentSizeInBytes) && Objects.equals(this.modelContentHashValue, that.modelContentHashValue) && Objects.equals(this.modelConfig, that.modelConfig) && Objects.equals(this.deploySetting, that.deploySetting) && Objects.equals(this.totalChunks, that.totalChunks) && Objects.equals(this.backendRoles, that.backendRoles) && this.accessMode == that.accessMode && Objects.equals(this.isAddAllBackendRoles, that.isAddAllBackendRoles) && Objects.equals(this.doesVersionCreateModelGroup, that.doesVersionCreateModelGroup) && Objects.equals(this.isHidden, that.isHidden) && Objects.equals(this.modelInterface, that.modelInterface);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.functionName, this.name, this.modelGroupId, this.description, this.version, this.isEnabled, this.rateLimiter, this.modelFormat, this.modelState, this.modelContentSizeInBytes, this.modelContentHashValue, this.modelConfig, this.deploySetting, this.totalChunks, this.backendRoles, this.accessMode, this.isAddAllBackendRoles, this.doesVersionCreateModelGroup, this.isHidden, this.modelInterface});
    }

    public String toString() {
        return "MLRegisterModelMetaInput{functionName=" + String.valueOf((Object)this.functionName) + ", name='" + this.name + "', modelGroupId='" + this.modelGroupId + "', description='" + this.description + "', version='" + this.version + "', isEnabled=" + this.isEnabled + ", rateLimiter=" + String.valueOf(this.rateLimiter) + ", modelFormat=" + String.valueOf((Object)this.modelFormat) + ", modelState=" + String.valueOf((Object)this.modelState) + ", modelContentSizeInBytes=" + this.modelContentSizeInBytes + ", modelContentHashValue='" + this.modelContentHashValue + "', modelConfig=" + String.valueOf(this.modelConfig) + ", deploySetting=" + String.valueOf(this.deploySetting) + ", totalChunks=" + this.totalChunks + ", backendRoles=" + String.valueOf(this.backendRoles) + ", accessMode=" + String.valueOf((Object)this.accessMode) + ", isAddAllBackendRoles=" + this.isAddAllBackendRoles + ", doesVersionCreateModelGroup=" + this.doesVersionCreateModelGroup + ", isHidden=" + this.isHidden + ", modelInterface=" + String.valueOf(this.modelInterface) + "}";
    }

    public static class Builder {
        private FunctionName functionName;
        private String name;
        private String modelGroupId;
        private String description;
        private String version;
        private Boolean isEnabled;
        private MLRateLimiter rateLimiter;
        private MLModelFormat modelFormat;
        private MLModelState modelState;
        private Long modelContentSizeInBytes;
        private String modelContentHashValue;
        private MLModelConfig modelConfig;
        private MLDeploySetting deploySetting;
        private Integer totalChunks;
        private List<String> backendRoles;
        private AccessMode accessMode;
        private Boolean isAddAllBackendRoles;
        private Boolean doesVersionCreateModelGroup;
        private Boolean isHidden;
        private Map<String, String> modelInterface;

        public Builder functionName(FunctionName functionName) {
            this.functionName = functionName;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder modelGroupId(String modelGroupId) {
            this.modelGroupId = modelGroupId;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder enabled(Boolean enabled) {
            this.isEnabled = enabled;
            return this;
        }

        public Builder rateLimiter(MLRateLimiter rateLimiter) {
            this.rateLimiter = rateLimiter;
            return this;
        }

        public Builder modelFormat(MLModelFormat modelFormat) {
            this.modelFormat = modelFormat;
            return this;
        }

        public Builder modelState(MLModelState modelState) {
            this.modelState = modelState;
            return this;
        }

        public Builder modelContentSizeInBytes(Long modelContentSizeInBytes) {
            this.modelContentSizeInBytes = modelContentSizeInBytes;
            return this;
        }

        public Builder modelContentHashValue(String modelContentHashValue) {
            this.modelContentHashValue = modelContentHashValue;
            return this;
        }

        public Builder modelConfig(MLModelConfig modelConfig) {
            this.modelConfig = modelConfig;
            return this;
        }

        public Builder deploySetting(MLDeploySetting deploySetting) {
            this.deploySetting = deploySetting;
            return this;
        }

        public Builder totalChunks(Integer totalChunks) {
            this.totalChunks = totalChunks;
            return this;
        }

        public Builder backendRoles(List<String> backendRoles) {
            this.backendRoles = backendRoles;
            return this;
        }

        public Builder accessMode(AccessMode accessMode) {
            this.accessMode = accessMode;
            return this;
        }

        public Builder addAllBackendRoles(Boolean addAllBackendRoles) {
            this.isAddAllBackendRoles = addAllBackendRoles;
            return this;
        }

        public Builder doesVersionCreateModelGroup(Boolean doesVersionCreateModelGroup) {
            this.doesVersionCreateModelGroup = doesVersionCreateModelGroup;
            return this;
        }

        public Builder hidden(Boolean hidden) {
            this.isHidden = hidden;
            return this;
        }

        public Builder modelInterface(Map<String, String> modelInterface) {
            this.modelInterface = modelInterface;
            return this;
        }

        public MLRegisterModelMetaInput build() {
            return new MLRegisterModelMetaInput(this.name, this.functionName, this.modelGroupId, this.version, this.description, this.isEnabled, this.rateLimiter, this.modelFormat, this.modelState, this.modelContentSizeInBytes, this.modelContentHashValue, this.modelConfig, this.deploySetting, this.totalChunks, this.backendRoles, this.accessMode, this.isAddAllBackendRoles, this.doesVersionCreateModelGroup, this.isHidden, this.modelInterface);
        }
    }
}

