/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.transport.connector;

import io.skylite.Version;
import io.skylite.core.common.Strings;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.common.util.CollectionUtils;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.ml.common.AccessMode;
import io.skylite.ml.common.CommonValue;
import io.skylite.ml.common.connector.ConnectorAction;
import io.skylite.ml.common.connector.ConnectorClientConfig;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class MLCreateConnectorInput
implements ToXContentObject,
Writeable {
    public static final String CONNECTOR_NAME_FIELD = "name";
    public static final String CONNECTOR_DESCRIPTION_FIELD = "description";
    public static final String CONNECTOR_VERSION_FIELD = "version";
    public static final String CONNECTOR_PROTOCOL_FIELD = "protocol";
    public static final String CONNECTOR_PARAMETERS_FIELD = "parameters";
    public static final String CONNECTOR_CREDENTIAL_FIELD = "credential";
    public static final String CONNECTOR_ACTIONS_FIELD = "actions";
    public static final String BACKEND_ROLES_FIELD = "backend_roles";
    public static final String ADD_ALL_BACKEND_ROLES_FIELD = "add_all_backend_roles";
    public static final String OWNER_FIELD = "owner";
    public static final String ACCESS_MODE_FIELD = "access_mode";
    public static final String DRY_RUN_FIELD = "dry_run";
    public static final String CONNECTOR_URL_FIELD = "url";
    public static final String CONNECTOR_HEADER_FIELD = "headers";
    private static final Version MINIMAL_SUPPORTED_VERSION_FOR_CLIENT_CONFIG = CommonValue.VERSION_2_13_0;
    public static final String DRY_RUN_CONNECTOR_NAME = "dryRunConnector";
    private String name;
    private String description;
    private String version;
    private String protocol;
    private String tenantId;
    private Map<String, String> parameters;
    private Map<String, String> credential;
    private List<ConnectorAction> actions;
    private List<String> backendRoles;
    private Boolean addAllBackendRoles;
    private AccessMode access;
    private boolean dryRun;
    private boolean updateConnector;
    private ConnectorClientConfig connectorClientConfig;
    private String url;
    private Map<String, String> headers;

    public MLCreateConnectorInput(String name, String description, String version, String protocol, Map<String, String> parameters, Map<String, String> credential, List<ConnectorAction> actions, List<String> backendRoles, Boolean addAllBackendRoles, AccessMode access, boolean dryRun, boolean updateConnector, ConnectorClientConfig connectorClientConfig, String tenantId, String url, Map<String, String> headers) {
        if (!dryRun && !updateConnector) {
            if (name == null) {
                throw new IllegalArgumentException("Connector name is null");
            }
            if (version == null) {
                throw new IllegalArgumentException("Connector version is null");
            }
            if (protocol == null) {
                throw new IllegalArgumentException("Connector protocol is null");
            }
            if (credential == null || credential.isEmpty()) {
                throw new IllegalArgumentException("Connector credential is null or empty list");
            }
        }
        this.name = name;
        this.description = description;
        this.version = version;
        this.protocol = protocol;
        this.parameters = parameters;
        this.credential = credential;
        this.actions = actions;
        this.backendRoles = backendRoles;
        this.addAllBackendRoles = addAllBackendRoles;
        this.access = access;
        this.dryRun = dryRun;
        this.updateConnector = updateConnector;
        this.connectorClientConfig = connectorClientConfig;
        this.tenantId = tenantId;
        this.url = url;
        this.headers = headers;
    }

    public MLCreateConnectorInput tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public static MLCreateConnectorInput parse(XContentParser parser) throws IOException {
        return MLCreateConnectorInput.parse(parser, false);
    }

    public static MLCreateConnectorInput parse(XContentParser parser, boolean updateConnector) throws IOException {
        String name = null;
        String description = null;
        String version = null;
        String protocol = null;
        Map<String, String> parameters = new HashMap<String, String>();
        Map<String, String> credential = new HashMap<String, String>();
        ArrayList<ConnectorAction> actions = null;
        ArrayList<String> backendRoles = null;
        Boolean addAllBackendRoles = null;
        AccessMode access = null;
        boolean dryRun = false;
        ConnectorClientConfig connectorClientConfig = null;
        String tenantId = null;
        String url = null;
        Map headers = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block34: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "name": {
                    name = parser.text();
                    continue block34;
                }
                case "description": {
                    description = parser.text();
                    continue block34;
                }
                case "version": {
                    version = parser.text();
                    continue block34;
                }
                case "protocol": {
                    protocol = parser.text();
                    continue block34;
                }
                case "parameters": {
                    parameters = Strings.getJsonParameterMap((Map)parser.map());
                    continue block34;
                }
                case "credential": {
                    credential = parser.mapStrings();
                    continue block34;
                }
                case "actions": {
                    actions = new ArrayList<ConnectorAction>();
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        actions.add(ConnectorAction.parse(parser));
                    }
                    continue block34;
                }
                case "backend_roles": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    backendRoles = new ArrayList<String>();
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        backendRoles.add(parser.text());
                    }
                    continue block34;
                }
                case "add_all_backend_roles": {
                    addAllBackendRoles = parser.booleanValue();
                    continue block34;
                }
                case "access_mode": {
                    access = AccessMode.from(parser.text());
                    continue block34;
                }
                case "dry_run": {
                    dryRun = parser.booleanValue();
                    continue block34;
                }
                case "client_config": {
                    connectorClientConfig = ConnectorClientConfig.parse(parser);
                    continue block34;
                }
                case "tenant_id": {
                    tenantId = parser.textOrNull();
                    continue block34;
                }
                case "url": {
                    url = parser.textOrNull();
                    continue block34;
                }
                case "headers": {
                    headers = parser.mapStrings();
                    continue block34;
                }
            }
            parser.skipChildren();
        }
        return new MLCreateConnectorInput(name, description, version, protocol, parameters, credential, actions, backendRoles, addAllBackendRoles, access, dryRun, updateConnector, connectorClientConfig, tenantId, url, headers);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.name != null) {
            builder.field(CONNECTOR_NAME_FIELD, this.name);
        }
        if (this.description != null) {
            builder.field(CONNECTOR_DESCRIPTION_FIELD, this.description);
        }
        if (this.version != null) {
            builder.field(CONNECTOR_VERSION_FIELD, this.version);
        }
        if (this.protocol != null) {
            builder.field(CONNECTOR_PROTOCOL_FIELD, this.protocol);
        }
        if (this.parameters != null) {
            builder.field(CONNECTOR_PARAMETERS_FIELD, this.parameters);
        }
        if (this.credential != null) {
            builder.field(CONNECTOR_CREDENTIAL_FIELD, this.credential);
        }
        if (this.actions != null) {
            builder.field(CONNECTOR_ACTIONS_FIELD, this.actions);
        }
        if (!CollectionUtils.isEmpty(this.backendRoles)) {
            builder.field(BACKEND_ROLES_FIELD, this.backendRoles);
        }
        if (this.addAllBackendRoles != null) {
            builder.field(ADD_ALL_BACKEND_ROLES_FIELD, this.addAllBackendRoles);
        }
        if (this.access != null) {
            builder.field(ACCESS_MODE_FIELD, (Object)this.access);
        }
        if (this.connectorClientConfig != null) {
            builder.field("client_config", (ToXContent)this.connectorClientConfig);
        }
        if (this.tenantId != null) {
            builder.field("tenant_id", this.tenantId);
        }
        builder.endObject();
        return builder;
    }

    public void writeTo(StreamOutput output) throws IOException {
        Version streamOutputVersion = output.getVersion();
        output.writeOptionalString(this.name);
        output.writeOptionalString(this.description);
        output.writeOptionalString(this.version);
        output.writeOptionalString(this.protocol);
        if (this.parameters != null) {
            output.writeBoolean(true);
            output.writeMap(this.parameters, StreamOutput::writeString, StreamOutput::writeString);
        } else {
            output.writeBoolean(false);
        }
        if (this.credential != null) {
            output.writeBoolean(true);
            output.writeMap(this.credential, StreamOutput::writeString, StreamOutput::writeString);
        } else {
            output.writeBoolean(false);
        }
        if (this.actions != null) {
            output.writeBoolean(true);
            output.writeInt(this.actions.size());
            for (ConnectorAction action : this.actions) {
                action.writeTo(output);
            }
        } else {
            output.writeBoolean(false);
        }
        if (!CollectionUtils.isEmpty(this.backendRoles)) {
            output.writeBoolean(true);
            output.writeStringCollection(this.backendRoles);
        } else {
            output.writeBoolean(false);
        }
        output.writeOptionalBoolean(this.addAllBackendRoles);
        if (this.access != null) {
            output.writeBoolean(true);
            output.writeEnum((Enum)this.access);
        } else {
            output.writeBoolean(false);
        }
        output.writeBoolean(this.dryRun);
        output.writeBoolean(this.updateConnector);
        if (streamOutputVersion.onOrAfter(MINIMAL_SUPPORTED_VERSION_FOR_CLIENT_CONFIG)) {
            if (this.connectorClientConfig != null) {
                output.writeBoolean(true);
                this.connectorClientConfig.writeTo(output);
            } else {
                output.writeBoolean(false);
            }
        }
        if (streamOutputVersion.onOrAfter((Version)CommonValue.VERSION_2_19_0)) {
            output.writeOptionalString(this.tenantId);
        }
    }

    public MLCreateConnectorInput(StreamInput input) throws IOException {
        Version streamInputVersion = input.getVersion();
        this.name = input.readOptionalString();
        this.description = input.readOptionalString();
        this.version = input.readOptionalString();
        this.protocol = input.readOptionalString();
        if (input.readBoolean()) {
            this.parameters = input.readMap(s -> s.readString(), s -> s.readString());
        }
        if (input.readBoolean()) {
            this.credential = input.readMap(s -> s.readString(), s -> s.readString());
        }
        if (input.readBoolean()) {
            this.actions = new ArrayList<ConnectorAction>();
            int size = input.readInt();
            for (int i = 0; i < size; ++i) {
                this.actions.add(new ConnectorAction(input));
            }
        }
        if (input.readBoolean()) {
            this.backendRoles = input.readList(StreamInput::readString);
        }
        this.addAllBackendRoles = input.readOptionalBoolean();
        if (input.readBoolean()) {
            this.access = (AccessMode)input.readEnum(AccessMode.class);
        }
        this.dryRun = input.readBoolean();
        this.updateConnector = input.readBoolean();
        if (streamInputVersion.onOrAfter(MINIMAL_SUPPORTED_VERSION_FOR_CLIENT_CONFIG) && input.readBoolean()) {
            this.connectorClientConfig = new ConnectorClientConfig(input);
        }
        this.tenantId = streamInputVersion.onOrAfter((Version)CommonValue.VERSION_2_19_0) ? input.readOptionalString() : null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getVersion() {
        return this.version;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getUrl() {
        return this.url;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public Map<String, String> getCredential() {
        return this.credential;
    }

    public List<ConnectorAction> getActions() {
        return this.actions;
    }

    public List<String> getBackendRoles() {
        return this.backendRoles;
    }

    public void setBackendRoles(List<String> backendRoles) {
        this.backendRoles = backendRoles;
    }

    public Boolean getAddAllBackendRoles() {
        return this.addAllBackendRoles;
    }

    public void setAddAllBackendRoles(Boolean addAllBackendRoles) {
        this.addAllBackendRoles = addAllBackendRoles;
    }

    public AccessMode getAccess() {
        return this.access;
    }

    public void setAccess(AccessMode access) {
        this.access = access;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public boolean isUpdateConnector() {
        return this.updateConnector;
    }

    public ConnectorClientConfig getConnectorClientConfig() {
        return this.connectorClientConfig;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MLCreateConnectorInput that = (MLCreateConnectorInput)o;
        return this.dryRun == that.dryRun && this.updateConnector == that.updateConnector && Objects.equals(this.name, that.name) && Objects.equals(this.description, that.description) && Objects.equals(this.version, that.version) && Objects.equals(this.protocol, that.protocol) && Objects.equals(this.tenantId, that.tenantId) && Objects.equals(this.parameters, that.parameters) && Objects.equals(this.credential, that.credential) && Objects.equals(this.actions, that.actions) && Objects.equals(this.backendRoles, that.backendRoles) && Objects.equals(this.addAllBackendRoles, that.addAllBackendRoles) && this.access == that.access && Objects.equals(this.connectorClientConfig, that.connectorClientConfig);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.description, this.version, this.protocol, this.tenantId, this.parameters, this.credential, this.actions, this.backendRoles, this.addAllBackendRoles, this.access, this.dryRun, this.updateConnector, this.connectorClientConfig});
    }

    public static class Builder {
        private String name;
        private String description;
        private String version;
        private String protocol;
        private Map<String, String> parameters;
        private Map<String, String> credential;
        private List<ConnectorAction> actions;
        private List<String> backendRoles;
        private Boolean addAllBackendRoles;
        private AccessMode access;
        private boolean dryRun;
        private boolean updateConnector;
        private ConnectorClientConfig connectorClientConfig;
        private String tenantId;
        private String url;
        private Map<String, String> headers;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder parameters(Map<String, String> parameters) {
            this.parameters = parameters;
            return this;
        }

        public Builder credential(Map<String, String> credential) {
            this.credential = credential;
            return this;
        }

        public Builder actions(List<ConnectorAction> actions) {
            this.actions = actions;
            return this;
        }

        public Builder backendRoles(List<String> backendRoles) {
            this.backendRoles = backendRoles;
            return this;
        }

        public Builder addAllBackendRoles(Boolean addAllBackendRoles) {
            this.addAllBackendRoles = addAllBackendRoles;
            return this;
        }

        public Builder access(AccessMode access) {
            this.access = access;
            return this;
        }

        public Builder dryRun(boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public Builder updateConnector(boolean updateConnector) {
            this.updateConnector = updateConnector;
            return this;
        }

        public Builder connectorClientConfig(ConnectorClientConfig connectorClientConfig) {
            this.connectorClientConfig = connectorClientConfig;
            return this;
        }

        public Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder headers(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public MLCreateConnectorInput build() {
            return new MLCreateConnectorInput(this.name, this.description, this.version, this.protocol, this.parameters, this.credential, this.actions, this.backendRoles, this.addAllBackendRoles, this.access, this.dryRun, this.updateConnector, this.connectorClientConfig, this.tenantId, this.url, this.headers);
        }
    }
}

