/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.transport.deploy;

import io.skylite.core.action.support.nodes.BaseNodeResponse;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentFragment;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MLDeployModelNodeResponse
extends BaseNodeResponse
implements ToXContentFragment {
    private static final Logger logger = LogManager.getLogger(MLDeployModelNodeResponse.class);
    private Map<String, String> modelDeployStatus;

    public MLDeployModelNodeResponse(DiscoveryNode node, Map<String, String> modelDeployStatus) {
        super(node);
        this.modelDeployStatus = modelDeployStatus;
    }

    public MLDeployModelNodeResponse(StreamInput in) throws IOException {
        super(in);
        if (in.readBoolean()) {
            this.modelDeployStatus = in.readMap(StreamInput::readString, StreamInput::readString);
        }
    }

    public static MLDeployModelNodeResponse readStats(StreamInput in) throws IOException {
        return new MLDeployModelNodeResponse(in);
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (this.modelDeployStatus != null && this.modelDeployStatus.size() > 0) {
            out.writeBoolean(true);
            out.writeMap(this.modelDeployStatus, StreamOutput::writeString, StreamOutput::writeString);
        } else {
            out.writeBoolean(false);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("stats");
        if (this.modelDeployStatus != null && this.modelDeployStatus.size() > 0) {
            for (Map.Entry<String, String> stat : this.modelDeployStatus.entrySet()) {
                builder.field(stat.getKey(), stat.getValue());
            }
        }
        builder.endObject();
        return builder;
    }
}

