/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.transport.model;

import io.skylite.Version;
import io.skylite.core.common.Strings;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.ml.common.CommonValue;
import io.skylite.ml.common.connector.Connector;
import io.skylite.ml.common.controller.MLRateLimiter;
import io.skylite.ml.common.model.Guardrails;
import io.skylite.ml.common.model.MLDeploySetting;
import io.skylite.ml.common.model.MLModel;
import io.skylite.ml.common.model.MLModelConfig;
import io.skylite.ml.common.model.TextEmbeddingModelConfig;
import io.skylite.ml.common.transport.connector.MLCreateConnectorInput;
import io.skylite.ml.common.transport.register.MLRegisterModelInput;
import java.io.IOException;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;

public class MLUpdateModelInput
implements ToXContentObject,
Writeable {
    public static final String MODEL_ID_FIELD = "model_id";
    public static final String DESCRIPTION_FIELD = "description";
    public static final String MODEL_VERSION_FIELD = "model_version";
    public static final String MODEL_NAME_FIELD = "name";
    public static final String MODEL_GROUP_ID_FIELD = "model_group_id";
    public static final String IS_ENABLED_FIELD = "is_enabled";
    public static final String RATE_LIMITER_FIELD = "rate_limiter";
    public static final String MODEL_CONFIG_FIELD = "model_config";
    public static final String DEPLOY_SETTING_FIELD = "deploy_setting";
    public static final String UPDATED_CONNECTOR_FIELD = "updated_connector";
    public static final String CONNECTOR_ID_FIELD = "connector_id";
    public static final String CONNECTOR_FIELD = "connector";
    public static final String LAST_UPDATED_TIME_FIELD = "last_updated_time";
    public static final String GUARDRAILS_FIELD = "guardrails";
    private String modelId;
    private String description;
    private String version;
    private String name;
    private String modelGroupId;
    private Boolean isEnabled;
    private MLRateLimiter rateLimiter;
    private MLModelConfig modelConfig;
    private MLDeploySetting deploySetting;
    private Connector updatedConnector;
    private String connectorId;
    private MLCreateConnectorInput connector;
    private Instant lastUpdateTime;
    private Guardrails guardrails;
    private String tenantId;
    private Map<String, String> modelInterface;

    public MLUpdateModelInput(String modelId, String description, String version, String name, String modelGroupId, Boolean isEnabled, MLRateLimiter rateLimiter, MLModelConfig modelConfig, MLDeploySetting deploySetting, Connector updatedConnector, String connectorId, MLCreateConnectorInput connector, Instant lastUpdateTime, Guardrails guardrails, Map<String, String> modelInterface, String tenantId) {
        this.modelId = modelId;
        this.description = description;
        this.version = version;
        this.name = name;
        this.modelGroupId = modelGroupId;
        this.isEnabled = isEnabled;
        this.rateLimiter = rateLimiter;
        this.modelConfig = modelConfig;
        this.deploySetting = deploySetting;
        this.updatedConnector = updatedConnector;
        this.connectorId = connectorId;
        this.connector = connector;
        this.lastUpdateTime = lastUpdateTime;
        this.guardrails = guardrails;
        this.modelInterface = modelInterface;
        this.tenantId = tenantId;
    }

    public MLUpdateModelInput(StreamInput in) throws IOException {
        Version streamInputVersion = in.getVersion();
        this.modelId = in.readString();
        this.description = in.readOptionalString();
        this.version = in.readOptionalString();
        this.name = in.readOptionalString();
        this.modelGroupId = in.readOptionalString();
        this.isEnabled = in.readOptionalBoolean();
        if (in.readBoolean()) {
            this.rateLimiter = new MLRateLimiter(in);
        }
        if (in.readBoolean()) {
            this.modelConfig = new TextEmbeddingModelConfig(in);
        }
        if (in.readBoolean()) {
            this.updatedConnector = Connector.fromStream(in);
        }
        this.connectorId = in.readOptionalString();
        if (in.readBoolean()) {
            this.connector = new MLCreateConnectorInput(in);
        }
        this.lastUpdateTime = in.readOptionalInstant();
        if (streamInputVersion.onOrAfter((Version)MLRegisterModelInput.MINIMAL_SUPPORTED_VERSION_FOR_GUARDRAILS_AND_AUTO_DEPLOY)) {
            if (in.readBoolean()) {
                this.guardrails = new Guardrails(in);
            }
            if (in.readBoolean()) {
                this.deploySetting = new MLDeploySetting(in);
            }
        }
        if (streamInputVersion.onOrAfter((Version)MLRegisterModelInput.MINIMAL_SUPPORTED_VERSION_FOR_INTERFACE) && in.readBoolean()) {
            this.modelInterface = in.readMap(StreamInput::readString, StreamInput::readString);
        }
        this.tenantId = streamInputVersion.onOrAfter((Version)CommonValue.VERSION_2_19_0) ? in.readOptionalString() : null;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(MODEL_ID_FIELD, this.modelId);
        if (this.name != null) {
            builder.field(MODEL_NAME_FIELD, this.name);
        }
        if (this.description != null) {
            builder.field(DESCRIPTION_FIELD, this.description);
        }
        if (this.version != null) {
            builder.field(MODEL_VERSION_FIELD, this.version);
        }
        if (this.modelGroupId != null) {
            builder.field(MODEL_GROUP_ID_FIELD, this.modelGroupId);
        }
        if (this.isEnabled != null) {
            builder.field(IS_ENABLED_FIELD, this.isEnabled);
        }
        if (this.rateLimiter != null) {
            builder.field(RATE_LIMITER_FIELD, (ToXContent)this.rateLimiter);
        }
        if (this.modelConfig != null) {
            builder.field(MODEL_CONFIG_FIELD, (ToXContent)this.modelConfig);
        }
        if (this.deploySetting != null) {
            builder.field(DEPLOY_SETTING_FIELD, (ToXContent)this.deploySetting);
        }
        if (this.updatedConnector != null) {
            builder.field(CONNECTOR_FIELD, (ToXContent)this.updatedConnector);
        }
        if (this.connectorId != null) {
            builder.field(CONNECTOR_ID_FIELD, this.connectorId);
        }
        if (this.lastUpdateTime != null) {
            builder.field(LAST_UPDATED_TIME_FIELD, this.lastUpdateTime.toEpochMilli());
        }
        if (this.guardrails != null) {
            builder.field(GUARDRAILS_FIELD, (ToXContent)this.guardrails);
        }
        if (this.modelInterface != null) {
            builder.field("interface", this.modelInterface);
        }
        if (this.tenantId != null) {
            builder.field("tenant_id", this.tenantId);
        }
        builder.endObject();
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        Version streamOutputVersion = out.getVersion();
        out.writeString(this.modelId);
        out.writeOptionalString(this.description);
        out.writeOptionalString(this.version);
        out.writeOptionalString(this.name);
        out.writeOptionalString(this.modelGroupId);
        out.writeOptionalBoolean(this.isEnabled);
        if (this.rateLimiter != null) {
            out.writeBoolean(true);
            this.rateLimiter.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        if (this.modelConfig != null) {
            out.writeBoolean(true);
            this.modelConfig.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        if (this.updatedConnector != null) {
            out.writeBoolean(true);
            this.updatedConnector.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalString(this.connectorId);
        if (this.connector != null) {
            out.writeBoolean(true);
            this.connector.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalInstant(this.lastUpdateTime);
        if (streamOutputVersion.onOrAfter((Version)MLRegisterModelInput.MINIMAL_SUPPORTED_VERSION_FOR_GUARDRAILS_AND_AUTO_DEPLOY)) {
            if (this.guardrails != null) {
                out.writeBoolean(true);
                this.guardrails.writeTo(out);
            } else {
                out.writeBoolean(false);
            }
            if (this.deploySetting != null) {
                out.writeBoolean(true);
                this.deploySetting.writeTo(out);
            } else {
                out.writeBoolean(false);
            }
        }
        if (streamOutputVersion.onOrAfter((Version)MLRegisterModelInput.MINIMAL_SUPPORTED_VERSION_FOR_INTERFACE)) {
            if (this.modelInterface != null) {
                out.writeBoolean(true);
                out.writeMap(this.modelInterface, StreamOutput::writeString, StreamOutput::writeString);
            } else {
                out.writeBoolean(false);
            }
        }
        if (streamOutputVersion.onOrAfter((Version)CommonValue.VERSION_2_19_0)) {
            out.writeOptionalString(this.tenantId);
        }
    }

    public static MLUpdateModelInput parse(XContentParser parser) throws IOException {
        String modelId = null;
        String description = null;
        String version = null;
        String name = null;
        String modelGroupId = null;
        Boolean isEnabled = null;
        MLRateLimiter rateLimiter = null;
        TextEmbeddingModelConfig modelConfig = null;
        MLDeploySetting deploySetting = null;
        Connector updatedConnector = null;
        String connectorId = null;
        MLCreateConnectorInput connector = null;
        Instant lastUpdateTime = null;
        Guardrails guardrails = null;
        Map modelInterface = null;
        String tenantId = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block30: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "model_id": {
                    modelId = parser.text();
                    continue block30;
                }
                case "description": {
                    description = parser.text();
                    continue block30;
                }
                case "name": {
                    name = parser.text();
                    continue block30;
                }
                case "model_group_id": {
                    modelGroupId = parser.text();
                    continue block30;
                }
                case "is_enabled": {
                    isEnabled = parser.booleanValue();
                    continue block30;
                }
                case "rate_limiter": {
                    rateLimiter = MLRateLimiter.parse(parser);
                    continue block30;
                }
                case "model_config": {
                    modelConfig = TextEmbeddingModelConfig.parse(parser);
                    continue block30;
                }
                case "deploy_setting": {
                    deploySetting = MLDeploySetting.parse(parser);
                    continue block30;
                }
                case "connector_id": {
                    connectorId = parser.text();
                    continue block30;
                }
                case "connector": {
                    connector = MLCreateConnectorInput.parse(parser, true);
                    continue block30;
                }
                case "guardrails": {
                    guardrails = Guardrails.parse(parser);
                    continue block30;
                }
                case "interface": {
                    modelInterface = Strings.filteredParameterMap((Map)parser.map(), MLModel.allowedInterfaceFieldKeys);
                    continue block30;
                }
                case "tenant_id": {
                    tenantId = parser.textOrNull();
                    continue block30;
                }
            }
            parser.skipChildren();
        }
        return new MLUpdateModelInput(modelId, description, version, name, modelGroupId, isEnabled, rateLimiter, modelConfig, deploySetting, updatedConnector, connectorId, connector, lastUpdateTime, guardrails, modelInterface, tenantId);
    }

    public String getModelId() {
        return this.modelId;
    }

    public String getDescription() {
        return this.description;
    }

    public String getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public String getModelGroupId() {
        return this.modelGroupId;
    }

    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    public MLRateLimiter getRateLimiter() {
        return this.rateLimiter;
    }

    public MLModelConfig getModelConfig() {
        return this.modelConfig;
    }

    public MLDeploySetting getDeploySetting() {
        return this.deploySetting;
    }

    public Connector getUpdatedConnector() {
        return this.updatedConnector;
    }

    public String getConnectorId() {
        return this.connectorId;
    }

    public MLCreateConnectorInput getConnector() {
        return this.connector;
    }

    public Instant getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public Guardrails getGuardrails() {
        return this.guardrails;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public Map<String, String> getModelInterface() {
        return this.modelInterface;
    }

    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setModelGroupId(String modelGroupId) {
        this.modelGroupId = modelGroupId;
    }

    public void setIsEnabled(Boolean enabled) {
        this.isEnabled = enabled;
    }

    public void setRateLimiter(MLRateLimiter rateLimiter) {
        this.rateLimiter = rateLimiter;
    }

    public void setModelConfig(MLModelConfig modelConfig) {
        this.modelConfig = modelConfig;
    }

    public void setDeploySetting(MLDeploySetting deploySetting) {
        this.deploySetting = deploySetting;
    }

    public void setUpdatedConnector(Connector updatedConnector) {
        this.updatedConnector = updatedConnector;
    }

    public void setConnectorId(String connectorId) {
        this.connectorId = connectorId;
    }

    public void setConnector(MLCreateConnectorInput connector) {
        this.connector = connector;
    }

    public void setLastUpdateTime(Instant lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public void setGuardrails(Guardrails guardrails) {
        this.guardrails = guardrails;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public void setModelInterface(Map<String, String> modelInterface) {
        this.modelInterface = modelInterface;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().modelId(this.modelId).description(this.description).version(this.version).name(this.name).modelGroupId(this.modelGroupId).setIsEnabled(this.isEnabled).rateLimiter(this.rateLimiter).modelConfig(this.modelConfig).deploySetting(this.deploySetting).updatedConnector(this.updatedConnector).connectorId(this.connectorId).connector(this.connector).lastUpdateTime(this.lastUpdateTime).guardrails(this.guardrails).tenantId(this.tenantId).modelInterface(this.modelInterface);
    }

    public String toString() {
        return "MLUpdateModelInput{modelId='" + this.modelId + "', description='" + this.description + "', version='" + this.version + "', name='" + this.name + "', modelGroupId='" + this.modelGroupId + "', isEnabled=" + this.isEnabled + ", rateLimiter=" + String.valueOf(this.rateLimiter) + ", modelConfig=" + String.valueOf(this.modelConfig) + ", deploySetting=" + String.valueOf(this.deploySetting) + ", updatedConnector=" + String.valueOf(this.updatedConnector) + ", connectorId='" + this.connectorId + "', connector=" + String.valueOf(this.connector) + ", lastUpdateTime=" + String.valueOf(this.lastUpdateTime) + ", guardrails=" + String.valueOf(this.guardrails) + ", tenantId='" + this.tenantId + "', modelInterface=" + String.valueOf(this.modelInterface) + "}";
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MLUpdateModelInput that = (MLUpdateModelInput)o;
        return Objects.equals(this.modelId, that.modelId) && Objects.equals(this.description, that.description) && Objects.equals(this.version, that.version) && Objects.equals(this.name, that.name) && Objects.equals(this.modelGroupId, that.modelGroupId) && Objects.equals(this.isEnabled, that.isEnabled) && Objects.equals(this.rateLimiter, that.rateLimiter) && Objects.equals(this.modelConfig, that.modelConfig) && Objects.equals(this.deploySetting, that.deploySetting) && Objects.equals(this.updatedConnector, that.updatedConnector) && Objects.equals(this.connectorId, that.connectorId) && Objects.equals(this.connector, that.connector) && Objects.equals(this.lastUpdateTime, that.lastUpdateTime) && Objects.equals(this.guardrails, that.guardrails) && Objects.equals(this.tenantId, that.tenantId) && Objects.equals(this.modelInterface, that.modelInterface);
    }

    public int hashCode() {
        return Objects.hash(this.modelId, this.description, this.version, this.name, this.modelGroupId, this.isEnabled, this.rateLimiter, this.modelConfig, this.deploySetting, this.updatedConnector, this.connectorId, this.connector, this.lastUpdateTime, this.guardrails, this.tenantId, this.modelInterface);
    }

    public static class Builder {
        private String modelId;
        private String description;
        private String version;
        private String name;
        private String modelGroupId;
        private Boolean isEnabled;
        private MLRateLimiter rateLimiter;
        private MLModelConfig modelConfig;
        private MLDeploySetting deploySetting;
        private Connector updatedConnector;
        private String connectorId;
        private MLCreateConnectorInput connector;
        private Instant lastUpdateTime;
        private Guardrails guardrails;
        private String tenantId;
        private Map<String, String> modelInterface;

        public Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder modelGroupId(String modelGroupId) {
            this.modelGroupId = modelGroupId;
            return this;
        }

        public Builder setIsEnabled(Boolean enabled) {
            this.isEnabled = enabled;
            return this;
        }

        public Builder rateLimiter(MLRateLimiter rateLimiter) {
            this.rateLimiter = rateLimiter;
            return this;
        }

        public Builder modelConfig(MLModelConfig modelConfig) {
            this.modelConfig = modelConfig;
            return this;
        }

        public Builder deploySetting(MLDeploySetting deploySetting) {
            this.deploySetting = deploySetting;
            return this;
        }

        public Builder updatedConnector(Connector updatedConnector) {
            this.updatedConnector = updatedConnector;
            return this;
        }

        public Builder connectorId(String connectorId) {
            this.connectorId = connectorId;
            return this;
        }

        public Builder connector(MLCreateConnectorInput connector) {
            this.connector = connector;
            return this;
        }

        public Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public Builder guardrails(Guardrails guardrails) {
            this.guardrails = guardrails;
            return this;
        }

        public Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public Builder modelInterface(Map<String, String> modelInterface) {
            this.modelInterface = modelInterface;
            return this;
        }

        public MLUpdateModelInput build() {
            return new MLUpdateModelInput(this.modelId, this.description, this.version, this.name, this.modelGroupId, this.isEnabled, this.rateLimiter, this.modelConfig, this.deploySetting, this.updatedConnector, this.connectorId, this.connector, this.lastUpdateTime, this.guardrails, this.modelInterface, this.tenantId);
        }
    }
}

