/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.transport.sync;

import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class MLSyncUpInput
implements Writeable {
    private boolean getDeployedModels;
    private Map<String, String[]> addedWorkerNodes;
    private Map<String, String[]> removedWorkerNodes;
    private Map<String, Set<String>> modelRoutingTable;
    private Map<String, Set<String>> runningDeployModelTasks;
    private boolean clearRoutingTable;
    private boolean syncRunningDeployModelTasks;
    private Map<String, Boolean> deployToAllNodes;

    public MLSyncUpInput(boolean getDeployedModels, Map<String, String[]> addedWorkerNodes, Map<String, String[]> removedWorkerNodes, Map<String, Set<String>> modelRoutingTable, Map<String, Set<String>> runningDeployModelTasks, Map<String, Boolean> deployToAllNodes, boolean clearRoutingTable, boolean syncRunningDeployModelTasks) {
        this.getDeployedModels = getDeployedModels;
        this.addedWorkerNodes = addedWorkerNodes;
        this.removedWorkerNodes = removedWorkerNodes;
        this.modelRoutingTable = modelRoutingTable;
        this.runningDeployModelTasks = runningDeployModelTasks;
        this.deployToAllNodes = deployToAllNodes;
        this.clearRoutingTable = clearRoutingTable;
        this.syncRunningDeployModelTasks = syncRunningDeployModelTasks;
    }

    public MLSyncUpInput() {
    }

    public MLSyncUpInput(StreamInput in) throws IOException {
        this.getDeployedModels = in.readBoolean();
        if (in.readBoolean()) {
            this.addedWorkerNodes = in.readMap(StreamInput::readString, StreamInput::readStringArray);
        }
        if (in.readBoolean()) {
            this.removedWorkerNodes = in.readMap(StreamInput::readString, StreamInput::readStringArray);
        }
        if (in.readBoolean()) {
            this.modelRoutingTable = in.readMap(StreamInput::readString, s -> s.readSet(StreamInput::readString));
        }
        if (in.readBoolean()) {
            this.runningDeployModelTasks = in.readMap(StreamInput::readString, s -> s.readSet(StreamInput::readString));
        }
        if (in.readBoolean()) {
            this.deployToAllNodes = in.readMap(StreamInput::readString, StreamInput::readOptionalBoolean);
        }
        this.clearRoutingTable = in.readBoolean();
        this.syncRunningDeployModelTasks = in.readBoolean();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.getDeployedModels);
        if (this.addedWorkerNodes != null && this.addedWorkerNodes.size() > 0) {
            out.writeBoolean(true);
            out.writeMap(this.addedWorkerNodes, StreamOutput::writeString, StreamOutput::writeStringArray);
        } else {
            out.writeBoolean(false);
        }
        if (this.removedWorkerNodes != null && this.removedWorkerNodes.size() > 0) {
            out.writeBoolean(true);
            out.writeMap(this.removedWorkerNodes, StreamOutput::writeString, StreamOutput::writeStringArray);
        } else {
            out.writeBoolean(false);
        }
        if (this.modelRoutingTable != null && this.modelRoutingTable.size() > 0) {
            out.writeBoolean(true);
            out.writeMap(this.modelRoutingTable, StreamOutput::writeString, StreamOutput::writeStringCollection);
        } else {
            out.writeBoolean(false);
        }
        if (this.runningDeployModelTasks != null && this.runningDeployModelTasks.size() > 0) {
            out.writeBoolean(true);
            out.writeMap(this.runningDeployModelTasks, StreamOutput::writeString, StreamOutput::writeStringCollection);
        } else {
            out.writeBoolean(false);
        }
        if (this.deployToAllNodes != null && this.deployToAllNodes.size() > 0) {
            out.writeBoolean(true);
            out.writeMap(this.deployToAllNodes, StreamOutput::writeString, StreamOutput::writeOptionalBoolean);
        } else {
            out.writeBoolean(false);
        }
        out.writeBoolean(this.clearRoutingTable);
        out.writeBoolean(this.syncRunningDeployModelTasks);
    }

    public boolean isGetDeployedModels() {
        return this.getDeployedModels;
    }

    public void setGetDeployedModels(boolean getDeployedModels) {
        this.getDeployedModels = getDeployedModels;
    }

    public Map<String, String[]> getAddedWorkerNodes() {
        return this.addedWorkerNodes;
    }

    public void setAddedWorkerNodes(Map<String, String[]> addedWorkerNodes) {
        this.addedWorkerNodes = addedWorkerNodes;
    }

    public Map<String, String[]> getRemovedWorkerNodes() {
        return this.removedWorkerNodes;
    }

    public void setRemovedWorkerNodes(Map<String, String[]> removedWorkerNodes) {
        this.removedWorkerNodes = removedWorkerNodes;
    }

    public Map<String, Set<String>> getModelRoutingTable() {
        return this.modelRoutingTable;
    }

    public void setModelRoutingTable(Map<String, Set<String>> modelRoutingTable) {
        this.modelRoutingTable = modelRoutingTable;
    }

    public Map<String, Set<String>> getRunningDeployModelTasks() {
        return this.runningDeployModelTasks;
    }

    public void setRunningDeployModelTasks(Map<String, Set<String>> runningDeployModelTasks) {
        this.runningDeployModelTasks = runningDeployModelTasks;
    }

    public boolean isClearRoutingTable() {
        return this.clearRoutingTable;
    }

    public void setClearRoutingTable(boolean clearRoutingTable) {
        this.clearRoutingTable = clearRoutingTable;
    }

    public boolean isSyncRunningDeployModelTasks() {
        return this.syncRunningDeployModelTasks;
    }

    public void setSyncRunningDeployModelTasks(boolean syncRunningDeployModelTasks) {
        this.syncRunningDeployModelTasks = syncRunningDeployModelTasks;
    }

    public Map<String, Boolean> getDeployToAllNodes() {
        return this.deployToAllNodes;
    }

    public void setDeployToAllNodes(Map<String, Boolean> deployToAllNodes) {
        this.deployToAllNodes = deployToAllNodes;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MLSyncUpInput that = (MLSyncUpInput)o;
        return this.getDeployedModels == that.getDeployedModels && this.clearRoutingTable == that.clearRoutingTable && this.syncRunningDeployModelTasks == that.syncRunningDeployModelTasks && Objects.equals(this.addedWorkerNodes, that.addedWorkerNodes) && Objects.equals(this.removedWorkerNodes, that.removedWorkerNodes) && Objects.equals(this.modelRoutingTable, that.modelRoutingTable) && Objects.equals(this.runningDeployModelTasks, that.runningDeployModelTasks) && Objects.equals(this.deployToAllNodes, that.deployToAllNodes);
    }

    public int hashCode() {
        return Objects.hash(this.getDeployedModels, this.addedWorkerNodes, this.removedWorkerNodes, this.modelRoutingTable, this.runningDeployModelTasks, this.clearRoutingTable, this.syncRunningDeployModelTasks, this.deployToAllNodes);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "MLSyncUpInput{getDeployedModels=" + this.getDeployedModels + ", addedWorkerNodes=" + String.valueOf(this.addedWorkerNodes) + ", removedWorkerNodes=" + String.valueOf(this.removedWorkerNodes) + ", modelRoutingTable=" + String.valueOf(this.modelRoutingTable) + ", runningDeployModelTasks=" + String.valueOf(this.runningDeployModelTasks) + ", clearRoutingTable=" + this.clearRoutingTable + ", syncRunningDeployModelTasks=" + this.syncRunningDeployModelTasks + ", deployToAllNodes=" + String.valueOf(this.deployToAllNodes) + "}";
    }

    public static class Builder {
        private boolean getDeployedModels;
        private Map<String, String[]> addedWorkerNodes;
        private Map<String, String[]> removedWorkerNodes;
        private Map<String, Set<String>> modelRoutingTable;
        private Map<String, Set<String>> runningDeployModelTasks;
        private boolean clearRoutingTable;
        private boolean syncRunningDeployModelTasks;
        private Map<String, Boolean> deployToAllNodes;

        public Builder getDeployedModels(boolean getDeployedModels) {
            this.getDeployedModels = getDeployedModels;
            return this;
        }

        public Builder addedWorkerNodes(Map<String, String[]> addedWorkerNodes) {
            this.addedWorkerNodes = addedWorkerNodes;
            return this;
        }

        public Builder removedWorkerNodes(Map<String, String[]> removedWorkerNodes) {
            this.removedWorkerNodes = removedWorkerNodes;
            return this;
        }

        public Builder modelRoutingTable(Map<String, Set<String>> modelRoutingTable) {
            this.modelRoutingTable = modelRoutingTable;
            return this;
        }

        public Builder runningDeployModelTasks(Map<String, Set<String>> runningDeployModelTasks) {
            this.runningDeployModelTasks = runningDeployModelTasks;
            return this;
        }

        public Builder clearRoutingTable(boolean clearRoutingTable) {
            this.clearRoutingTable = clearRoutingTable;
            return this;
        }

        public Builder syncRunningDeployModelTasks(boolean syncRunningDeployModelTasks) {
            this.syncRunningDeployModelTasks = syncRunningDeployModelTasks;
            return this;
        }

        public Builder deployToAllNodes(Map<String, Boolean> deployToAllNodes) {
            this.deployToAllNodes = deployToAllNodes;
            return this;
        }

        public MLSyncUpInput build() {
            return new MLSyncUpInput(this.getDeployedModels, this.addedWorkerNodes, this.removedWorkerNodes, this.modelRoutingTable, this.runningDeployModelTasks, this.deployToAllNodes, this.clearRoutingTable, this.syncRunningDeployModelTasks);
        }
    }
}

