/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.transport.sync;

import io.skylite.Version;
import io.skylite.core.action.support.nodes.BaseNodeResponse;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.ml.common.model.MLDeploySetting;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MLSyncUpNodeResponse
extends BaseNodeResponse {
    private static final Logger log = LogManager.getLogger(MLSyncUpNodeResponse.class);
    private String modelStatus;
    private String[] deployedModelIds;
    private String[] runningDeployModelIds;
    private String[] runningDeployModelTaskIds;
    private String[] expiredModelIds;

    public MLSyncUpNodeResponse(DiscoveryNode node, String modelStatus, String[] deployedModelIds, String[] runningDeployModelIds, String[] runningDeployModelTaskIds, String[] expiredModelIds) {
        super(node);
        this.modelStatus = modelStatus;
        this.deployedModelIds = deployedModelIds;
        this.runningDeployModelIds = runningDeployModelIds;
        this.runningDeployModelTaskIds = runningDeployModelTaskIds;
        this.expiredModelIds = expiredModelIds;
    }

    public MLSyncUpNodeResponse(StreamInput in) throws IOException {
        super(in);
        Version streamInputVersion = in.getVersion();
        this.modelStatus = in.readOptionalString();
        this.deployedModelIds = in.readOptionalStringArray();
        this.runningDeployModelIds = in.readOptionalStringArray();
        this.runningDeployModelTaskIds = in.readOptionalStringArray();
        if (streamInputVersion.onOrAfter((Version)MLDeploySetting.MINIMAL_SUPPORTED_VERSION_FOR_MODEL_TTL)) {
            this.expiredModelIds = in.readOptionalStringArray();
        }
    }

    public static MLSyncUpNodeResponse readStats(StreamInput in) throws IOException {
        return new MLSyncUpNodeResponse(in);
    }

    public void writeTo(StreamOutput out) throws IOException {
        Version streamOutputVersion = out.getVersion();
        super.writeTo(out);
        out.writeOptionalString(this.modelStatus);
        out.writeOptionalStringArray(this.deployedModelIds);
        out.writeOptionalStringArray(this.runningDeployModelIds);
        out.writeOptionalStringArray(this.runningDeployModelTaskIds);
        if (streamOutputVersion.onOrAfter((Version)MLDeploySetting.MINIMAL_SUPPORTED_VERSION_FOR_MODEL_TTL)) {
            out.writeOptionalStringArray(this.expiredModelIds);
        }
    }

    public String getModelStatus() {
        return this.modelStatus;
    }

    public String[] getDeployedModelIds() {
        return this.deployedModelIds;
    }

    public String[] getRunningDeployModelIds() {
        return this.runningDeployModelIds;
    }

    public String[] getRunningDeployModelTaskIds() {
        return this.runningDeployModelTaskIds;
    }

    public String[] getExpiredModelIds() {
        return this.expiredModelIds;
    }
}

