/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.transport.undeploy;

import io.skylite.Version;
import io.skylite.common.action.ActionRequestValidationException;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.ml.common.CommonValue;
import io.skylite.ml.common.transport.MLTaskRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

public class MLUndeployModelsRequest
extends MLTaskRequest {
    private static final String MODEL_IDS_FIELD = "model_ids";
    private static final String NODE_IDS_FIELD = "node_ids";
    private final String[] modelIds;
    private final String[] nodeIds;
    private final boolean async;
    private final String tenantId;

    public MLUndeployModelsRequest(String[] modelIds, String[] nodeIds, boolean async, boolean dispatchTask, String tenantId) {
        super(dispatchTask);
        this.modelIds = modelIds;
        this.nodeIds = nodeIds;
        this.async = async;
        this.tenantId = tenantId;
    }

    public MLUndeployModelsRequest(String[] modelIds, String[] nodeIds, String tenantId) {
        this(modelIds, nodeIds, false, false, tenantId);
    }

    public MLUndeployModelsRequest(StreamInput in) throws IOException {
        super(in);
        Version streamInputVersion = in.getVersion();
        this.modelIds = in.readOptionalStringArray();
        this.nodeIds = in.readOptionalStringArray();
        this.async = in.readBoolean();
        this.tenantId = streamInputVersion.onOrAfter((Version)CommonValue.VERSION_2_19_0) ? in.readOptionalString() : null;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException exception = null;
        return exception;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        Version streamOutputVersion = out.getVersion();
        out.writeOptionalStringArray(this.modelIds);
        out.writeOptionalStringArray(this.nodeIds);
        out.writeBoolean(this.async);
        if (streamOutputVersion.onOrAfter((Version)CommonValue.VERSION_2_19_0)) {
            out.writeOptionalString(this.tenantId);
        }
    }

    public static MLUndeployModelsRequest parse(XContentParser parser, String modelId) throws IOException {
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        ArrayList<String> modelIdList = new ArrayList<String>();
        ArrayList<String> nodeIdList = new ArrayList<String>();
        String tenantId = null;
        block10: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "model_ids": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        modelIdList.add(parser.text());
                    }
                    continue block10;
                }
                case "node_ids": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        nodeIdList.add(parser.text());
                    }
                    continue block10;
                }
                case "tenant_id": {
                    tenantId = parser.textOrNull();
                    continue block10;
                }
            }
            parser.skipChildren();
        }
        String[] modelIds = modelIdList.toArray(new String[0]);
        String[] nodeIds = nodeIdList.toArray(new String[0]);
        return new MLUndeployModelsRequest(modelIds, nodeIds, false, true, tenantId);
    }

    /*
     * Exception decompiling
     */
    public static MLUndeployModelsRequest fromActionRequest(ActionRequest actionRequest) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String[] getModelIds() {
        return this.modelIds;
    }

    public String[] getNodeIds() {
        return this.nodeIds;
    }

    public boolean isAsync() {
        return this.async;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "MLUndeployModelsRequest{modelIds=" + Arrays.toString(this.modelIds) + ", nodeIds=" + Arrays.toString(this.nodeIds) + ", async=" + this.async + ", tenantId='" + this.tenantId + "', dispatchTask=" + this.dispatchTask + ", requestID='" + this.requestID + "'}";
    }

    public static class Builder {
        private String[] modelIds;
        private String[] nodeIds;
        private boolean async;
        private boolean dispatchTask;
        private String tenantId;

        public Builder modelIds(String[] modelIds) {
            this.modelIds = modelIds;
            return this;
        }

        public Builder nodeIds(String[] nodeIds) {
            this.nodeIds = nodeIds;
            return this;
        }

        public Builder async(boolean async) {
            this.async = async;
            return this;
        }

        public Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public Builder dispatchTask(boolean dispatchTask) {
            this.dispatchTask = dispatchTask;
            return this;
        }

        public MLUndeployModelsRequest build() {
            return new MLUndeployModelsRequest(this.modelIds, this.nodeIds, this.async, this.dispatchTask, this.tenantId);
        }
    }
}

