/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.transport.upload_chunk;

import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;

public class MLUploadModelChunkInput
implements ToXContentObject,
Writeable {
    public static final String CONTENT_FIELD = "model_content";
    public static final String MODEL_ID_FIELD = "model_id";
    public static final String CHUNK_NUMBER_FIELD = "chunk_number";
    private byte[] content;
    private String modelId;
    private Integer chunkNumber;

    public MLUploadModelChunkInput(String modelId, Integer chunkNumber, byte[] content) {
        this.content = content;
        this.modelId = modelId;
        this.chunkNumber = chunkNumber;
    }

    public MLUploadModelChunkInput(StreamInput in) throws IOException {
        this.modelId = in.readString();
        this.chunkNumber = in.readInt();
        boolean uploadModel = in.readBoolean();
        if (uploadModel) {
            this.content = in.readByteArray();
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.modelId);
        out.writeInt(this.chunkNumber.intValue());
        if (this.content == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeByteArray(this.content);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(MODEL_ID_FIELD, this.modelId);
        builder.field(CHUNK_NUMBER_FIELD, this.chunkNumber);
        builder.field(CONTENT_FIELD, this.content);
        builder.endObject();
        return builder;
    }

    public static MLUploadModelChunkInput parse(XContentParser parser, byte[] content) throws IOException {
        Integer chunkNumber = null;
        String modelId = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block8: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "model_id": {
                    modelId = parser.text();
                    continue block8;
                }
                case "chunk_number": {
                    chunkNumber = parser.intValue();
                    continue block8;
                }
            }
            parser.skipChildren();
        }
        return new MLUploadModelChunkInput(modelId, chunkNumber, content);
    }

    public byte[] getContent() {
        return this.content;
    }

    public void setContent(byte[] content) {
        this.content = content;
    }

    public String getModelId() {
        return this.modelId;
    }

    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    public Integer getChunkNumber() {
        return this.chunkNumber;
    }

    public void setChunkNumber(Integer chunkNumber) {
        this.chunkNumber = chunkNumber;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MLUploadModelChunkInput that = (MLUploadModelChunkInput)o;
        return Objects.deepEquals(this.content, that.content) && Objects.equals(this.modelId, that.modelId) && Objects.equals(this.chunkNumber, that.chunkNumber);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.content), this.modelId, this.chunkNumber);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().content(this.content).modelId(this.modelId).chunkNumber(this.chunkNumber);
    }

    public String toString() {
        return "MLUploadModelChunkInput{content=" + Arrays.toString(this.content) + ", modelId='" + this.modelId + "', chunkNumber=" + this.chunkNumber + "}";
    }

    public static class Builder {
        private byte[] content;
        private String modelId;
        private Integer chunkNumber;

        public Builder content(byte[] content) {
            this.content = content;
            return this;
        }

        public Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public Builder chunkNumber(Integer chunkNumber) {
            this.chunkNumber = chunkNumber;
            return this;
        }

        public MLUploadModelChunkInput build() {
            return new MLUploadModelChunkInput(this.modelId, this.chunkNumber, this.content);
        }
    }
}

