/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.ValidationMessage;
import io.skylite.SkyliteParseException;
import io.skylite.core.common.Strings;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class StringUtils {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public static void validateSchema(String schemaString, String instanceString) {
        try {
            JsonNode schemaNode = MAPPER.readTree(schemaString);
            JsonSchema schema = JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)SpecVersion.VersionFlag.V202012).getSchema(schemaNode);
            JsonNode jsonNode = MAPPER.readTree(instanceString);
            Set errors = schema.validate(jsonNode);
            if (!errors.isEmpty()) {
                String errorMessage = errors.stream().map(ValidationMessage::getMessage).collect(Collectors.joining(", "));
                throw new SkyliteParseException("Validation failed: " + errorMessage + " for instance: " + instanceString + " with schema: " + schemaString, new Object[0]);
            }
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Invalid JSON format: " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new SkyliteParseException("Schema validation failed: " + e.getMessage(), (Throwable)e, new Object[0]);
        }
    }

    public static Map<String, String> getParameterMap(Map<String, ?> parameterObjs) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (String key : parameterObjs.keySet()) {
            Object value = parameterObjs.get(key);
            try {
                AccessController.doPrivileged(() -> {
                    if (value instanceof String) {
                        parameters.put(key, (String)value);
                    } else {
                        parameters.put(key, Strings.toJson((Object)value));
                    }
                    return null;
                });
            }
            catch (PrivilegedActionException e) {
                throw new RuntimeException(e);
            }
        }
        return parameters;
    }
}

