/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.ml.common.utils;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ZipUtils {
    private static final Logger log = LogManager.getLogger(ZipUtils.class);

    public static void unzip(Path zipFilePath, Path destDir) {
        if (!Files.exists(zipFilePath, new LinkOption[0]) || !Files.isRegularFile(zipFilePath, new LinkOption[0])) {
            throw new IllegalArgumentException("Invalid zip file: " + String.valueOf(zipFilePath));
        }
        if (!Files.isDirectory(destDir, new LinkOption[0])) {
            try {
                Files.createDirectories(destDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to create destination directory: " + String.valueOf(destDir), e);
            }
        }
        try (InputStream fis = Files.newInputStream(zipFilePath, new OpenOption[0]);
             ZipInputStream zipInputStream = new ZipInputStream(fis);){
            ZipEntry entry;
            while ((entry = zipInputStream.getNextEntry()) != null) {
                Path entryPath = destDir.resolve(entry.getName()).toAbsolutePath();
                if (!entryPath.normalize().startsWith(destDir.toAbsolutePath())) {
                    throw new SecurityException("Blocked zip entry outside destination folder: " + entry.getName());
                }
                if (entry.isDirectory()) {
                    Files.createDirectories(entryPath, new FileAttribute[0]);
                } else {
                    Files.createDirectories(entryPath.getParent(), new FileAttribute[0]);
                    try {
                        Files.copy(zipInputStream, entryPath, StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Error writing file: " + String.valueOf(entryPath), e);
                    }
                }
                zipInputStream.closeEntry();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error extracting zip file: " + String.valueOf(zipFilePath), e);
        }
    }
}

