/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.spatial4j.io;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.ParseException;
import java.util.ArrayList;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.context.SpatialContextFactory;
import org.locationtech.spatial4j.exception.InvalidShapeException;
import org.locationtech.spatial4j.io.ShapeReader;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.ShapeFactory;

public class PolyshapeReader
implements ShapeReader {
    final SpatialContext ctx;
    final ShapeFactory shpFactory;

    public PolyshapeReader(SpatialContext ctx, SpatialContextFactory factory) {
        this.ctx = ctx;
        this.shpFactory = ctx.getShapeFactory();
    }

    @Override
    public String getFormatName() {
        return "POLY";
    }

    @Override
    public Shape read(Object value) throws IOException, ParseException, InvalidShapeException {
        return this.read(new StringReader(value.toString().trim()));
    }

    @Override
    public Shape readIfSupported(Object value) throws InvalidShapeException {
        String v = value.toString().trim();
        char first = v.charAt(0);
        if (first >= '0' && first <= '9') {
            try {
                return this.read(new StringReader(v));
            }
            catch (ParseException parseException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public final Shape read(Reader r) throws ParseException, IOException {
        XReader reader = new XReader(r, this.shpFactory);
        Double arg = null;
        Shape lastShape = null;
        ArrayList<Shape> shapes = null;
        block8: while (!reader.isDone()) {
            char event = reader.readKey();
            if (event < '0' || event > '9') {
                if (event == ' ') continue;
                throw new ParseException("expecting a shape key.  not '" + event + "'", -1);
            }
            if (lastShape != null) {
                if (shapes == null) {
                    shapes = new ArrayList<Shape>();
                }
                shapes.add(lastShape);
            }
            arg = null;
            if (reader.peek() == 40) {
                reader.readKey();
                arg = reader.readDouble();
                if (reader.readKey() != ')') {
                    throw new ParseException("expecting an argument end", -1);
                }
            }
            if (reader.isEvent()) {
                throw new ParseException("Invalid input. Event should be followed by data", -1);
            }
            switch (event) {
                case '0': {
                    lastShape = this.shpFactory.pointXY(this.shpFactory.normX(reader.readLat()), this.shpFactory.normY(reader.readLng()));
                    continue block8;
                }
                case '1': {
                    ShapeFactory.LineStringBuilder lineBuilder = this.shpFactory.lineString();
                    reader.readPoints(lineBuilder);
                    if (arg != null) {
                        lineBuilder.buffer(this.shpFactory.normDist(arg));
                    }
                    lastShape = lineBuilder.build();
                    continue block8;
                }
                case '5': {
                    double lat1 = this.shpFactory.normX(reader.readLat());
                    double lon1 = this.shpFactory.normY(reader.readLng());
                    lastShape = this.shpFactory.rect(lat1, this.shpFactory.normX(reader.readLat()), lon1, this.shpFactory.normY(reader.readLng()));
                    continue block8;
                }
                case '3': {
                    lastShape = reader.readPoints(this.shpFactory.multiPoint()).build();
                    continue block8;
                }
                case '4': {
                    if (arg == null) {
                        throw new IllegalArgumentException("the input should have a radius argument");
                    }
                    lastShape = this.shpFactory.circle(this.shpFactory.normX(reader.readLat()), this.shpFactory.normY(reader.readLng()), this.shpFactory.normDist(arg));
                    continue block8;
                }
                case '2': {
                    lastShape = this.readPolygon(reader);
                    continue block8;
                }
            }
            throw new ParseException("unhandled key: " + event, -1);
        }
        if (shapes != null) {
            if (lastShape != null) {
                shapes.add(lastShape);
            }
            ShapeFactory.MultiShapeBuilder<Shape> multiBuilder = this.shpFactory.multiShape(Shape.class);
            for (Shape shp : shapes) {
                multiBuilder.add(shp);
            }
            return multiBuilder.build();
        }
        return lastShape;
    }

    protected Shape readPolygon(XReader reader) throws IOException {
        ShapeFactory.PolygonBuilder polyBuilder = this.shpFactory.polygon();
        reader.readPoints(polyBuilder);
        if (!reader.isDone() && reader.peek() == 40) {
            ArrayList list = new ArrayList();
            while (reader.isEvent() && reader.peek() == 40) {
                reader.readKey();
                reader.readPoints(polyBuilder.hole()).endHole();
            }
        }
        return polyBuilder.build();
    }

    public static class XReader {
        int lat = 0;
        int lng = 0;
        int head = -1;
        final Reader input;
        final ShapeFactory shpFactory;

        public XReader(Reader input, ShapeFactory shpFactory) throws IOException {
            this.input = input;
            this.shpFactory = shpFactory;
            this.head = input.read();
        }

        public <T extends ShapeFactory.PointsBuilder> T readPoints(T builder) throws IOException {
            while (this.isData()) {
                builder.pointXY(this.shpFactory.normX(this.readLat()), this.shpFactory.normY(this.readLng()));
            }
            return builder;
        }

        public double readLat() throws IOException {
            this.lat += this.readInt();
            return (double)this.lat * 1.0E-5;
        }

        public double readLng() throws IOException {
            this.lng += this.readInt();
            return (double)this.lng * 1.0E-5;
        }

        public double readDouble() throws IOException {
            return (double)this.readInt() * 1.0E-5;
        }

        public int peek() {
            return this.head;
        }

        public char readKey() throws IOException {
            this.lng = 0;
            this.lat = 0;
            char key = (char)this.head;
            this.head = this.input.read();
            return key;
        }

        public boolean isData() {
            return this.head >= 63;
        }

        public boolean isDone() {
            return this.head < 0;
        }

        public boolean isEvent() {
            return this.head > 0 && this.head < 63;
        }

        int readInt() throws IOException {
            int b;
            int result = 1;
            int shift = 0;
            do {
                b = this.head - 63 - 1;
                result += b << shift;
                shift += 5;
                this.head = this.input.read();
            } while (b >= 31);
            return (result & 1) != 0 ? ~(result >> 1) : result >> 1;
        }
    }
}

